/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.plugin.monitor;

import com.ydn.jsrv.config.yaml.GlobalYamlConfiguration;
import com.ydn.jsrv.util.StrUtil;

public class MonitorConfig {
    public static final String SERVER_TYPE = "server";
    public static final String MANAGER_TYPE = "manager";
    public static final String APP_TYPE = "jsrv.monitor.type";
    public static final String APPID = "jsrv.monitor.appId";
    public static final String QUEUE = "jsrv.monitor.queue";
    public static final String MANAGER_IP = "jsrv.monitor.manager.ip";
    public static final String MANAGER_PORT = "jsrv.monitor.manager.port";
    public static final String KEEP_ALIVE = "jsrv.monitor.server.keepAlive";
    public static final String CONSUME_CLASS = "jsrv.monitor.consumeClass";
    protected String appId;
    protected String managerIp;
    protected String managerPort;
    protected long keepAlive;
    protected String appType;
    protected long queue;
    protected String consumeClass;
    private static final MonitorConfig monitorConfig = new MonitorConfig();

    public static MonitorConfig me() {
        return monitorConfig;
    }

    private MonitorConfig() {
        this.init();
    }

    protected void init() {
        this.appId = GlobalYamlConfiguration.getString(APPID);
        this.managerIp = GlobalYamlConfiguration.getString(MANAGER_IP);
        this.managerPort = GlobalYamlConfiguration.getString(MANAGER_PORT);
        this.appType = GlobalYamlConfiguration.getString(APP_TYPE);
        this.queue = GlobalYamlConfiguration.getLong(QUEUE, 6000L);
        this.keepAlive = GlobalYamlConfiguration.getLong(KEEP_ALIVE, 5000L);
        this.consumeClass = GlobalYamlConfiguration.getString(CONSUME_CLASS);
    }

    public boolean isServer() {
        return SERVER_TYPE.equals(this.appType);
    }

    public boolean isManager() {
        return MANAGER_TYPE.equalsIgnoreCase(this.appType);
    }

    public static boolean startMonitor() {
        return !StrUtil.isBlank(GlobalYamlConfiguration.getString(APP_TYPE));
    }

    public String getManagerPort() {
        return this.managerPort;
    }

    public String getManagerIp() {
        return this.managerIp;
    }

    public String getAppType() {
        return this.appType;
    }

    public long getKeepAlive() {
        return this.keepAlive;
    }

    public String getConsumeClass() {
        return this.consumeClass;
    }
}

