/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.plugin.monitor;

import com.ydn.jsrv.plugin.monitor.JsrvMonitor;
import com.ydn.jsrv.plugin.monitor.Monitor;
import com.ydn.jsrv.plugin.monitor.MonitorDataMap;
import com.ydn.jsrv.plugin.monitor.service.MonitorService;
import com.ydn.jsrv.plugin.monitor.service.MonitorServiceFactory;
import com.ydn.jsrv.tool.concurrent.ListenableFuture;
import com.ydn.jsrv.tool.concurrent.ListenableFutureTask;
import com.ydn.jsrv.tool.concurrent.NamedThreadFactory;
import com.ydn.jsrv.util.LogUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class MonitorFactory {
    private static final Map<String, Monitor> MONITORS = new ConcurrentHashMap<String, Monitor>();
    private static final ReentrantLock LOCK = new ReentrantLock();
    private static final Map<String, ListenableFuture<Monitor>> FUTURES = new ConcurrentHashMap<String, ListenableFuture<Monitor>>();
    private static final ExecutorService executor = new ThreadPoolExecutor(0, 10, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new NamedThreadFactory("JsvMonitorCreator", true));

    public static Collection<Monitor> getMonitors() {
        return Collections.unmodifiableCollection(MONITORS.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Monitor getMonitor(MonitorDataMap monitorDataMap) {
        String key = monitorDataMap.getPath();
        LOCK.lock();
        try {
            Monitor monitor = MONITORS.get(key);
            Future future = FUTURES.get(key);
            if (monitor != null || future != null) {
                Monitor monitor2 = monitor;
                return monitor2;
            }
            ListenableFutureTask<Monitor> listenableFutureTask = ListenableFutureTask.create(new MonitorCreator(monitorDataMap));
            listenableFutureTask.addListener(new MonitorListener(key));
            executor.execute(listenableFutureTask);
            FUTURES.put(key, listenableFutureTask);
            Monitor monitor3 = null;
            return monitor3;
        }
        finally {
            LOCK.unlock();
        }
    }

    protected Monitor createMonitor(MonitorDataMap monitorDataMap) {
        MonitorService monitorService = MonitorServiceFactory.me().getMonitorService();
        return new JsrvMonitor(monitorService, monitorDataMap);
    }

    class MonitorCreator
    implements Callable<Monitor> {
        private MonitorDataMap monitorDataMap;

        public MonitorCreator(MonitorDataMap monitorDataMap) {
            this.monitorDataMap = monitorDataMap;
        }

        @Override
        public Monitor call() throws Exception {
            Monitor monitor = MonitorFactory.this.createMonitor(this.monitorDataMap);
            return monitor;
        }
    }

    class MonitorListener
    implements Runnable {
        private String key;

        public MonitorListener(String key) {
            this.key = key;
        }

        @Override
        public void run() {
            try {
                ListenableFuture listenableFuture = (ListenableFuture)FUTURES.get(this.key);
                MONITORS.put(this.key, listenableFuture.get());
                FUTURES.remove(this.key);
            }
            catch (InterruptedException var2) {
                LogUtil.warn("Thread was interrupted unexpectedly, monitor will never be got.");
                FUTURES.remove(this.key);
            }
            catch (ExecutionException var3) {
                LogUtil.warn("Create monitor failed, monitor data will not be collected until you fix this problem. ", var3);
            }
        }
    }
}

