/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.plugin.monitor;

import com.ydn.jsrv.plugin.IPlugin;
import com.ydn.jsrv.plugin.monitor.HeartThread;
import com.ydn.jsrv.plugin.monitor.MonitorConfig;
import com.ydn.jsrv.plugin.monitor.service.ManagerMonitorService;
import com.ydn.jsrv.plugin.monitor.service.MonitorServiceFactory;
import com.ydn.jsrv.plugin.monitor.service.ServerMonitorService;
import com.ydn.jsrv.plugin.monitor.statistics.LocalConsume;
import com.ydn.jsrv.plugin.monitor.statistics.MonitorConsume;
import com.ydn.jsrv.plugin.monitor.statistics.MonitorConsumeFactory;
import com.ydn.jsrv.util.ClassUtils;
import com.ydn.jsrv.util.StrUtil;

public class MonitorPlugin
implements IPlugin {
    protected volatile boolean isStarted = false;
    protected MonitorConfig monitorConfig;

    @Override
    public boolean start() {
        if (this.isStarted) {
            return true;
        }
        this.monitorConfig = MonitorConfig.me();
        this.monitorConfig.init();
        if (this.monitorConfig.isServer()) {
            MonitorServiceFactory.me().setMonitorService(new ServerMonitorService());
            new Thread(new HeartThread()).start();
        }
        if (this.monitorConfig.isManager()) {
            MonitorServiceFactory.me().setMonitorService(new ManagerMonitorService());
        }
        if (StrUtil.isBlank(this.monitorConfig.getConsumeClass())) {
            MonitorConsumeFactory.me().setMonitorConsume(new LocalConsume());
        } else {
            Class monitorConsume = ClassUtils.getClass(this.monitorConfig.getConsumeClass());
            try {
                MonitorConsumeFactory.me().setMonitorConsume((MonitorConsume)monitorConsume.newInstance());
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    @Override
    public boolean stop() {
        return true;
    }
}

