/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.plugin.monitor.active;

import com.ydn.jsrv.config.yaml.GlobalYamlConfiguration;
import com.ydn.jsrv.plugin.monitor.MonitorConfig;
import com.ydn.jsrv.tool.http.HttpSender;
import com.ydn.jsrv.util.HttpUtil;
import com.ydn.jsrv.util.LogUtil;
import com.ydn.jsrv.util.StrUtil;
import java.util.HashMap;
import java.util.Map;

public class ActiveFactory {
    private static ActiveFactory activeFactory;
    public static final String state_start = "0";
    public static final String state_running = "1";
    public static final String site = "MONITOR_SEND";
    private String serverIp = HttpUtil.getServerIp();
    private String serverPort = GlobalYamlConfiguration.getString("undertow.port");
    private boolean startActive = true;
    private String httpUrl;

    private ActiveFactory() {
        String managerIp = MonitorConfig.me().getManagerIp();
        String managerPort = MonitorConfig.me().getManagerPort();
        if (StrUtil.isBlank(managerIp) || StrUtil.isBlank(managerPort)) {
            this.startActive = false;
        }
        this.httpUrl = "http://" + managerIp + ":" + managerPort + "/jsrv/_monitor/send";
    }

    public static ActiveFactory me() {
        if (activeFactory == null) {
            activeFactory = new ActiveFactory();
        }
        return activeFactory;
    }

    public Map getActiveMap() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("serverIp", this.serverIp);
        params.put("serverPort", this.serverPort);
        return params;
    }

    public void sendStart() {
        if (this.startActive) {
            try {
                HttpSender.sendPost(this.httpUrl, this.getStartActiveMap(), site);
            }
            catch (Exception e) {
                LogUtil.error("send start error", e);
            }
        }
    }

    public void keepActive() {
        if (this.startActive) {
            try {
                HttpSender.sendPost(this.httpUrl, this.getRunningActiveMap(), site);
            }
            catch (Exception e) {
                LogUtil.error("send finished error", e);
            }
        }
    }

    public Map getStartActiveMap() {
        Map map = this.getActiveMap();
        map.put("state", state_start);
        return map;
    }

    public Map getRunningActiveMap() {
        Map map = this.getActiveMap();
        map.put("state", state_running);
        return map;
    }

    public boolean isStart(String state) {
        return state_start.equals(state);
    }

    public String getServerIp() {
        return this.serverIp;
    }

    public String getServerPort() {
        return this.serverPort;
    }
}

