/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.plugin.monitor.handler;

import com.alibaba.fastjson.JSON;
import com.ydn.jsrv.handler.Handler;
import com.ydn.jsrv.plugin.monitor.MonitorDataMap;
import com.ydn.jsrv.plugin.monitor.active.ActiveFactory;
import com.ydn.jsrv.plugin.monitor.active.ServerKit;
import com.ydn.jsrv.plugin.monitor.service.MonitorServiceFactory;
import com.ydn.jsrv.util.HandlerUtil;
import com.ydn.jsrv.util.HttpUtil;
import com.ydn.jsrv.util.LogUtil;
import com.ydn.jsrv.util.MapTools;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MonitorHandler
extends Handler {
    protected MonitorHandler() {
    }

    @Override
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, boolean[] isHandled) {
        if (target.startsWith("/jsrv/_monitor")) {
            isHandled[0] = true;
            this.route(target, request, response);
        } else {
            this.next.handle(target, request, response, isHandled);
        }
    }

    private void route(String target, HttpServletRequest request, HttpServletResponse response) {
        if (target.equals("/jsrv/_monitor/send")) {
            MonitorHandler.parseServerHeart(request);
            return;
        }
        if (target.equals("/jsrv/_monitor/data")) {
            this.parseParam(request);
            return;
        }
        HandlerUtil.render(request, response, 404);
    }

    public static void parseServerHeart(HttpServletRequest request) {
        Map postParamMap = (Map)JSON.parseObject((String)HttpUtil.readData(request), Map.class);
        String serverIp = MapTools.getString(postParamMap, "serverIp");
        String serverPort = MapTools.getString(postParamMap, "serverPort");
        String state = MapTools.getString(postParamMap, "state");
        if (ActiveFactory.me().isStart(state)) {
            ServerKit.serverIn(serverIp, serverPort);
        } else {
            ServerKit.start(serverIp, serverPort);
        }
    }

    private void parseParam(HttpServletRequest request) {
        String paramStr = HttpUtil.readData(request);
        Map param = (Map)JSON.parseObject((String)paramStr, Map.class);
        Object objData = param.get("data");
        if (objData == null) {
            return;
        }
        try {
            if (objData instanceof Map) {
                Map mapData = (Map)objData;
                MonitorDataMap monitorDataMap = new MonitorDataMap();
                monitorDataMap.putAll(mapData);
                MonitorServiceFactory.me().getMonitorService().collect(monitorDataMap);
            } else {
                LogUtil.error("parse param  error not MonitorDataMap");
            }
        }
        catch (Exception e) {
            LogUtil.error("parse url error", e);
        }
    }
}

