/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.render;

import com.alibaba.fastjson.JSON;
import com.ydn.jsrv.exception.RenderException;
import com.ydn.jsrv.render.Render;
import com.ydn.jsrv.util.Ret;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;

public class JsonRender
extends Render {
    protected static final String contentType = "application/json; charset=" + encoding;
    protected Ret ret;

    public JsonRender(Ret ret) {
        this.ret = ret;
    }

    @Override
    public void render() {
        this.addAttrs();
        PrintWriter writer = null;
        try {
            this.response.setContentType(contentType);
            writer = this.response.getWriter();
            writer.write(JSON.toJSONString((Object)this.ret));
        }
        catch (IOException e) {
            throw new RenderException(e);
        }
    }

    protected void addAttrs() {
        Enumeration attrs = this.request.getAttributeNames();
        while (attrs.hasMoreElements()) {
            String key = (String)attrs.nextElement();
            if (this.ret.get(key) != null) continue;
            Object value = this.request.getAttribute(key);
            this.ret.put(key, value);
        }
    }
}

