/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.route;

import com.ydn.jsrv.aop.Aop;
import com.ydn.jsrv.interceptor.Interceptor;
import com.ydn.jsrv.interceptor.InterceptorManager;
import com.ydn.jsrv.util.StrUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Routes {
    private static List<Routes> routesList = new ArrayList<Routes>();
    private static Map<String, String> indexList = new HashMap<String, String>();
    private List<Route> routeItemList = new ArrayList<Route>();
    private List<Interceptor> injectInters = new ArrayList<Interceptor>();
    private boolean clearAfterMapping = false;

    public abstract void config();

    public Routes add(Routes routes) {
        routes.config();
        routesList.add(routes);
        return this;
    }

    public Routes add(String controllerKey, String controllerPkg) {
        this.routeItemList.add(new Route(controllerKey, controllerPkg));
        return this;
    }

    public Routes addIndex(String key, String index) {
        indexList.put(key, index);
        return this;
    }

    public Routes addInterceptor(Interceptor interceptor) {
        Aop.inject(interceptor);
        this.injectInters.add(interceptor);
        return this;
    }

    public List<Route> getRouteItemList() {
        return this.routeItemList;
    }

    public Interceptor[] getInterceptors() {
        return this.injectInters.size() > 0 ? this.injectInters.toArray(new Interceptor[this.injectInters.size()]) : InterceptorManager.NULL_INTERS;
    }

    public static Map<String, String> getIndexList() {
        return indexList;
    }

    public static List<Routes> getRoutesList() {
        return routesList;
    }

    public void setClearAfterMapping(boolean clearAfterMapping) {
        this.clearAfterMapping = clearAfterMapping;
    }

    public void clear() {
        if (this.clearAfterMapping) {
            routesList = null;
            this.routeItemList = null;
            this.injectInters = null;
        }
    }

    public static class Route {
        private String routeKey;
        private String routePkg;

        public Route(String routeKey, String routePkg) {
            if (StrUtil.isBlank(routeKey)) {
                throw new IllegalArgumentException("routeKey can not be blank");
            }
            if (routePkg == null) {
                routePkg = "";
            }
            this.routeKey = this.processRouteKey(routeKey);
            this.routePkg = routePkg;
        }

        private String processRouteKey(String routeKey) {
            if (!(routeKey = routeKey.trim()).startsWith("/")) {
                routeKey = "/" + routeKey;
            }
            return routeKey;
        }

        public String getRouteKey() {
            return this.routeKey;
        }

        public void setRouteKey(String routeKey) {
            this.routeKey = routeKey;
        }

        public String getRoutePkg() {
            return this.routePkg;
        }

        public void setRoutePkg(String routePkg) {
            this.routePkg = routePkg;
        }
    }
}

