/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.tool.generator;

import com.ydn.jsrv.config.yaml.GlobalYamlConfiguration;
import com.ydn.jsrv.plugin.activerecord.dialect.Dialect;
import com.ydn.jsrv.plugin.druid.DruidPlugin;
import com.ydn.jsrv.tool.generator.BaseModelGenerator;
import com.ydn.jsrv.tool.generator.DataDictionaryGenerator;
import com.ydn.jsrv.tool.generator.MappingGenerator;
import com.ydn.jsrv.tool.generator.MetaBuilder;
import com.ydn.jsrv.tool.generator.ModelGenerator;
import com.ydn.jsrv.tool.generator.TableMeta;
import com.ydn.jsrv.tool.generator.TypeMapping;
import java.util.List;
import javax.sql.DataSource;

public class Generator {
    protected Dialect dialect = null;
    protected MetaBuilder metaBuilder;
    protected BaseModelGenerator baseModelGenerator;
    protected ModelGenerator modelGenerator;
    protected MappingGenerator mappingGenerator;
    protected DataDictionaryGenerator dataDictionaryGenerator;
    protected boolean generateDataDictionary = false;
    private String sourceName = "default";

    public Generator(String baseModelPackageName, String baseModelOutputDir, String modelPackageName, String modelOutputDir, String mappingOutPutDir) {
        this.init(baseModelPackageName, baseModelOutputDir, modelPackageName, modelOutputDir, mappingOutPutDir);
    }

    public Generator(String baseModelPackageName, String baseModelOutputDir, String modelPackageName, String modelOutputDir, String mappingOutPutDir, String sourceName) {
        this.sourceName = sourceName;
        this.init(baseModelPackageName, baseModelOutputDir, modelPackageName, modelOutputDir, mappingOutPutDir);
    }

    private void init(String baseModelPackageName, String baseModelOutputDir, String modelPackageName, String modelOutputDir, String mappingOutPutDir) {
        DataSource dataSource = this.getDataSource();
        if (dataSource == null) {
            throw new IllegalArgumentException("dataSource can not be null.");
        }
        this.metaBuilder = new MetaBuilder(dataSource);
        this.baseModelGenerator = new BaseModelGenerator(baseModelPackageName, baseModelOutputDir);
        this.modelGenerator = new ModelGenerator(modelPackageName, baseModelPackageName, modelOutputDir);
        this.mappingGenerator = new MappingGenerator(modelPackageName, mappingOutPutDir, this.sourceName);
        this.dataDictionaryGenerator = new DataDictionaryGenerator(dataSource, this.modelGenerator.modelOutputDir);
    }

    public void setGenerateRemarks(boolean generateRemarks) {
        if (this.metaBuilder != null) {
            this.metaBuilder.setGenerateRemarks(generateRemarks);
        }
    }

    public void setTypeMapping(TypeMapping typeMapping) {
        this.metaBuilder.setTypeMapping(typeMapping);
    }

    public void setmappingGenerator(MappingGenerator mappingGenerator) {
        if (mappingGenerator != null) {
            this.mappingGenerator = mappingGenerator;
        }
    }

    public void setDataDictionaryGenerator(DataDictionaryGenerator dataDictionaryGenerator) {
        if (dataDictionaryGenerator != null) {
            this.dataDictionaryGenerator = dataDictionaryGenerator;
        }
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }

    public void setBaseModelTemplate(String baseModelTemplate) {
        this.baseModelGenerator.setTemplate(baseModelTemplate);
    }

    public void setGenerateChainSetter(boolean generateChainSetter) {
        this.baseModelGenerator.setGenerateChainSetter(generateChainSetter);
    }

    public void setRemovedTableNamePrefixes(String ... removedTableNamePrefixes) {
        this.metaBuilder.setRemovedTableNamePrefixes(removedTableNamePrefixes);
    }

    public void addExcludedTable(String ... excludedTables) {
        this.metaBuilder.addExcludedTable(excludedTables);
    }

    public void setModelTemplate(String modelTemplate) {
        if (this.modelGenerator != null) {
            this.modelGenerator.setTemplate(modelTemplate);
        }
    }

    public void setGenerateDaoInModel(boolean generateDaoInModel) {
        if (this.modelGenerator != null) {
            this.modelGenerator.setGenerateDaoInModel(generateDaoInModel);
        }
    }

    public void setGenerateDataDictionary(boolean generateDataDictionary) {
        this.generateDataDictionary = generateDataDictionary;
    }

    public void setSourceName(String sourceName) {
        this.mappingGenerator.setSource(sourceName);
    }

    public void setDataDictionaryOutputDir(String dataDictionaryOutputDir) {
        if (this.dataDictionaryGenerator != null) {
            this.dataDictionaryGenerator.setDataDictionaryOutputDir(dataDictionaryOutputDir);
        }
    }

    public void setDataDictionaryFileName(String dataDictionaryFileName) {
        if (this.dataDictionaryGenerator != null) {
            this.dataDictionaryGenerator.setDataDictionaryFileName(dataDictionaryFileName);
        }
    }

    public void generate() {
        if (this.dialect != null) {
            this.metaBuilder.setDialect(this.dialect);
        }
        long start = System.currentTimeMillis();
        List<TableMeta> tableMetas = this.metaBuilder.build();
        if (tableMetas.size() == 0) {
            System.out.println("TableMeta \u6570\u91cf\u4e3a 0\uff0c\u4e0d\u751f\u6210\u4efb\u4f55\u6587\u4ef6");
            return;
        }
        this.baseModelGenerator.generate(tableMetas);
        if (this.modelGenerator != null) {
            this.modelGenerator.generate(tableMetas);
        }
        if (this.mappingGenerator != null) {
            this.mappingGenerator.generate(tableMetas);
        }
        if (this.dataDictionaryGenerator != null && this.generateDataDictionary) {
            this.dataDictionaryGenerator.generate(tableMetas);
        }
        long usedTime = (System.currentTimeMillis() - start) / 1000L;
        System.out.println("Generate complete in " + usedTime + " seconds.");
    }

    private DataSource getDataSource() {
        return this.getDataSource(this.sourceName);
    }

    private DataSource getDataSource(String _source) {
        if (!GlobalYamlConfiguration.me().isBuilded()) {
            GlobalYamlConfiguration.me().buildPropFile();
        }
        DruidPlugin druidPlugin = new DruidPlugin(GlobalYamlConfiguration.getDbValue(_source, "url"), GlobalYamlConfiguration.getDbValue(_source, "username"), GlobalYamlConfiguration.getDbValue(_source, "pwd"));
        druidPlugin.start();
        return druidPlugin.getDataSource();
    }
}

