/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.tool.template.expr.ast;

import com.ydn.jsrv.tool.template.TemplateException;
import com.ydn.jsrv.tool.template.expr.Sym;
import com.ydn.jsrv.tool.template.expr.ast.Expr;
import com.ydn.jsrv.tool.template.expr.ast.Id;
import com.ydn.jsrv.tool.template.stat.Location;
import com.ydn.jsrv.tool.template.stat.ParseException;
import com.ydn.jsrv.tool.template.stat.Scope;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;

public class IncDec
extends Expr {
    private Sym op;
    private String id;
    private boolean isPost;

    public IncDec(Sym op, boolean isPost, Expr id, Location location) {
        if (id == null) {
            throw new ParseException(op.value() + " operator requires target to be operational", location);
        }
        if (!(id instanceof Id)) {
            throw new ParseException(op.value() + " operator only supports identifiers", location);
        }
        this.op = op;
        this.id = ((Id)id).getId();
        this.isPost = isPost;
        this.location = location;
    }

    @Override
    public Object eval(Scope scope) {
        Number newValue;
        Map map = scope.getMapOfValue(this.id);
        if (map == null) {
            if (scope.getCtrl().isNullSafe()) {
                return null;
            }
            throw new TemplateException("The target of " + this.op.value() + " operator can not be null", this.location);
        }
        Object value = map.get(this.id);
        if (!(value instanceof Number)) {
            throw new TemplateException(this.op.value() + " operator only support int long float double and BigDecimal type", this.location);
        }
        switch (this.op) {
            case INC: {
                newValue = this.inc((Number)value);
                break;
            }
            case DEC: {
                newValue = this.dec((Number)value);
                break;
            }
            default: {
                throw new TemplateException("Unsupported operator: " + this.op.value(), this.location);
            }
        }
        map.put(this.id, newValue);
        return this.isPost ? value : newValue;
    }

    private Number inc(Number num) {
        if (num instanceof Integer) {
            return num.intValue() + 1;
        }
        if (num instanceof Long) {
            return num.longValue() + 1L;
        }
        if (num instanceof Float) {
            return Float.valueOf(num.floatValue() + 1.0f);
        }
        if (num instanceof Double) {
            return num.doubleValue() + 1.0;
        }
        if (num instanceof BigDecimal) {
            return ((BigDecimal)num).add(BigDecimal.ONE);
        }
        if (num instanceof BigInteger) {
            return ((BigInteger)num).add(BigInteger.ONE);
        }
        if (num instanceof Short) {
            return (short)((Short)num + 1);
        }
        if (num instanceof Byte) {
            return (byte)((Byte)num + 1);
        }
        return num.intValue() + 1;
    }

    private Number dec(Number num) {
        if (num instanceof Integer) {
            return num.intValue() - 1;
        }
        if (num instanceof Long) {
            return num.longValue() - 1L;
        }
        if (num instanceof Float) {
            return Float.valueOf(num.floatValue() - 1.0f);
        }
        if (num instanceof Double) {
            return num.doubleValue() - 1.0;
        }
        if (num instanceof BigDecimal) {
            return ((BigDecimal)num).subtract(BigDecimal.ONE);
        }
        if (num instanceof BigInteger) {
            return ((BigInteger)num).subtract(BigInteger.ONE);
        }
        if (num instanceof Short) {
            return (short)((Short)num - 1);
        }
        if (num instanceof Byte) {
            return (byte)((Byte)num - 1);
        }
        return num.intValue() - 1;
    }
}

