/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.tool.template.expr.ast;

import com.ydn.jsrv.tool.template.expr.ast.MethodInfo;
import com.ydn.jsrv.tool.template.expr.ast.MethodKit;
import com.ydn.jsrv.util.ReflectKit;
import com.ydn.jsrv.util.SyncWriteMap;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SharedMethodKit {
    private static final Set<Long> excludedMethodKey;
    private final List<SharedMethodInfo> sharedMethodList = new ArrayList<SharedMethodInfo>();
    private final HashMap<Long, SharedMethodInfo> methodCache = new SyncWriteMap<Long, SharedMethodInfo>(512, 0.25f);

    public SharedMethodInfo getSharedMethodInfo(String methodName, Object[] argValues) {
        Class<?>[] argTypes = MethodKit.getArgTypes(argValues);
        Long key = SharedMethodKit.getSharedMethodKey(methodName, argTypes);
        SharedMethodInfo method = this.methodCache.get(key);
        if (method == null && (method = this.doGetSharedMethodInfo(methodName, argTypes)) != null) {
            this.methodCache.putIfAbsent(key, method);
        }
        return method;
    }

    private SharedMethodInfo doGetSharedMethodInfo(String methodName, Class<?>[] argTypes) {
        for (SharedMethodInfo smi : this.sharedMethodList) {
            if (!smi.getName().equals(methodName)) continue;
            Class<?>[] paraTypes = smi.getParameterTypes();
            if (MethodKit.matchFixedArgTypes(paraTypes, argTypes)) {
                return smi;
            }
            if (!smi.isVarArgs() || !MethodKit.matchVarArgTypes(paraTypes, argTypes)) continue;
            return smi;
        }
        return null;
    }

    public void addSharedMethod(Object sharedMethodFromObject) {
        this.addSharedMethod(sharedMethodFromObject.getClass(), sharedMethodFromObject);
    }

    public void addSharedMethod(Class<?> sharedMethodFromClass) {
        this.addSharedMethod(sharedMethodFromClass, ReflectKit.newInstance(sharedMethodFromClass));
    }

    public void addSharedStaticMethod(Class<?> sharedStaticMethodFromClass) {
        this.addSharedMethod(sharedStaticMethodFromClass, null);
    }

    public void removeSharedMethod(String methodName) {
        Iterator<SharedMethodInfo> it = this.sharedMethodList.iterator();
        while (it.hasNext()) {
            if (!it.next().getName().equals(methodName)) continue;
            it.remove();
        }
    }

    public void removeSharedMethod(Class<?> sharedClass) {
        Iterator<SharedMethodInfo> it = this.sharedMethodList.iterator();
        while (it.hasNext()) {
            if (it.next().getClazz() != sharedClass) continue;
            it.remove();
        }
    }

    public void removeSharedMethod(Method method) {
        Iterator<SharedMethodInfo> it = this.sharedMethodList.iterator();
        while (it.hasNext()) {
            SharedMethodInfo current = it.next();
            String methodName = method.getName();
            if (!current.getName().equals(methodName)) continue;
            Long key = SharedMethodKit.getSharedMethodKey(methodName, method.getParameterTypes());
            if (!current.getKey().equals(key)) continue;
            it.remove();
        }
    }

    private synchronized void addSharedMethod(Class<?> sharedClass, Object target) {
        Method[] methods;
        if (MethodKit.isForbiddenClass(sharedClass)) {
            throw new IllegalArgumentException("Forbidden class: " + sharedClass.getName());
        }
        for (Method method : methods = sharedClass.getMethods()) {
            Long key = SharedMethodKit.getSharedMethodKey(method.getName(), method.getParameterTypes());
            if (excludedMethodKey.contains(key)) continue;
            for (SharedMethodInfo smi : this.sharedMethodList) {
                if (!smi.getKey().equals(key)) continue;
                throw new RuntimeException("The shared method is already exists : " + smi.toString());
            }
            if (target != null) {
                this.sharedMethodList.add(new SharedMethodInfo(key, sharedClass, method, target));
                continue;
            }
            if (!Modifier.isStatic(method.getModifiers())) continue;
            this.sharedMethodList.add(new SharedMethodInfo(key, sharedClass, method, null));
        }
    }

    private static Long getSharedMethodKey(String methodName, Class<?>[] argTypes) {
        long hash = -3750763034362895579L;
        hash ^= (long)methodName.hashCode();
        hash *= 1099511628211L;
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                Class<?> type = argTypes[i];
                if (type != null) {
                    hash ^= (long)type.getName().hashCode();
                    hash *= 1099511628211L;
                    continue;
                }
                hash ^= (long)"null".hashCode();
                hash *= 1099511628211L;
            }
        }
        return hash;
    }

    static {
        Method[] methods;
        excludedMethodKey = new HashSet<Long>();
        for (Method method : methods = Object.class.getMethods()) {
            Long key = SharedMethodKit.getSharedMethodKey(method.getName(), method.getParameterTypes());
            excludedMethodKey.add(key);
        }
    }

    static class SharedMethodInfo
    extends MethodInfo {
        final Object target;

        private SharedMethodInfo(Long key, Class<?> clazz, Method method, Object target) {
            super(key, clazz, method);
            this.target = target;
        }

        public Object invoke(Object ... args) throws ReflectiveOperationException {
            return super.invoke(this.target, args);
        }

        Class<?> getClazz() {
            return this.clazz;
        }
    }
}

