/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.tool.template.expr.ast;

import com.ydn.jsrv.tool.template.TemplateException;
import com.ydn.jsrv.tool.template.expr.Sym;
import com.ydn.jsrv.tool.template.expr.ast.Const;
import com.ydn.jsrv.tool.template.expr.ast.Expr;
import com.ydn.jsrv.tool.template.stat.Location;
import com.ydn.jsrv.tool.template.stat.ParseException;
import com.ydn.jsrv.tool.template.stat.Scope;
import java.math.BigDecimal;

public class Unary
extends Expr {
    private Sym op;
    private Expr expr;

    public Unary(Sym op, Expr expr, Location location) {
        if (expr == null) {
            throw new ParseException("The parameter of \"" + op.value() + "\" operator can not be blank", location);
        }
        this.op = op;
        this.expr = expr;
        this.location = location;
    }

    @Override
    public Object eval(Scope scope) {
        Object value = this.expr.eval(scope);
        if (value == null) {
            if (scope.getCtrl().isNullSafe()) {
                return null;
            }
            throw new TemplateException("The parameter of \"" + this.op.value() + "\" operator can not be blank", this.location);
        }
        if (!(value instanceof Number)) {
            throw new TemplateException(this.op.value() + " operator only support int long float double BigDecimal type", this.location);
        }
        switch (this.op) {
            case ADD: {
                return value;
            }
            case SUB: {
                Number n = (Number)value;
                if (n instanceof Integer) {
                    return -n.intValue();
                }
                if (n instanceof Long) {
                    return -n.longValue();
                }
                if (n instanceof Float) {
                    return Float.valueOf(-n.floatValue());
                }
                if (n instanceof Double) {
                    return -n.doubleValue();
                }
                if (n instanceof BigDecimal) {
                    return ((BigDecimal)n).negate();
                }
                throw new TemplateException("Unsupported data type: " + n.getClass().getName(), this.location);
            }
        }
        throw new TemplateException("Unsupported operator: " + this.op.value(), this.location);
    }

    public Expr toConstIfPossible() {
        if (!(this.expr instanceof Const) || this.op != Sym.SUB && this.op != Sym.ADD && this.op != Sym.NOT) {
            return this;
        }
        Expr ret = this;
        Const c = (Const)this.expr;
        if (this.op == Sym.SUB) {
            if (c.isInt()) {
                ret = new Const(Sym.INT, -c.getInt().intValue());
            } else if (c.isLong()) {
                ret = new Const(Sym.LONG, -c.getLong().longValue());
            } else if (c.isFloat()) {
                ret = new Const(Sym.FLOAT, Float.valueOf(-c.getFloat().floatValue()));
            } else if (c.isDouble()) {
                ret = new Const(Sym.DOUBLE, -c.getDouble().doubleValue());
            }
        } else if (this.op == Sym.ADD) {
            if (c.isNumber()) {
                ret = c;
            }
        } else if (this.op == Sym.NOT && c.isBoolean()) {
            ret = c.isTrue() ? Const.FALSE : Const.TRUE;
        }
        return ret;
    }

    public String toString() {
        return this.op.toString() + this.expr.toString();
    }
}

