/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.tool.template.ext.directive;

import com.ydn.jsrv.tool.template.Directive;
import com.ydn.jsrv.tool.template.Env;
import com.ydn.jsrv.tool.template.TemplateException;
import com.ydn.jsrv.tool.template.expr.ast.Expr;
import com.ydn.jsrv.tool.template.expr.ast.ExprList;
import com.ydn.jsrv.tool.template.io.Writer;
import com.ydn.jsrv.tool.template.stat.ParseException;
import com.ydn.jsrv.tool.template.stat.Scope;
import java.text.DecimalFormat;

public class NumberDirective
extends Directive {
    private Expr valueExpr;
    private Expr patternExpr;
    private int paraNum;

    @Override
    public void setExprList(ExprList exprList) {
        this.paraNum = exprList.length();
        if (this.paraNum == 0) {
            throw new ParseException("The parameter of #number directive can not be blank", this.location);
        }
        if (this.paraNum > 2) {
            throw new ParseException("Wrong number parameter of #number directive, two parameters allowed at most", this.location);
        }
        if (this.paraNum == 1) {
            this.valueExpr = exprList.getExpr(0);
            this.patternExpr = null;
        } else if (this.paraNum == 2) {
            this.valueExpr = exprList.getExpr(0);
            this.patternExpr = exprList.getExpr(1);
        }
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        Object value = this.valueExpr.eval(scope);
        if (value == null) {
            return;
        }
        if (this.paraNum == 1) {
            this.outputWithoutPattern(writer, value);
        } else if (this.paraNum == 2) {
            this.outputWithPattern(scope, writer, value);
        }
    }

    private void outputWithoutPattern(Writer writer, Object value) {
        String ret = new DecimalFormat().format(value);
        this.write(writer, ret);
    }

    private void outputWithPattern(Scope scope, Writer writer, Object value) {
        Object pattern = this.patternExpr.eval(scope);
        if (!(pattern instanceof String)) {
            throw new TemplateException("The sencond parameter pattern of #number directive must be String", this.location);
        }
        String ret = new DecimalFormat((String)pattern).format(value);
        this.write(writer, ret);
    }
}

