/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.tool.template.stat.ast;

import com.ydn.jsrv.tool.template.Env;
import com.ydn.jsrv.tool.template.TemplateException;
import com.ydn.jsrv.tool.template.io.Writer;
import com.ydn.jsrv.tool.template.stat.Ctrl;
import com.ydn.jsrv.tool.template.stat.Scope;
import com.ydn.jsrv.tool.template.stat.ast.NullStat;
import com.ydn.jsrv.tool.template.stat.ast.Stat;
import java.util.List;

public class StatList
extends Stat {
    public static final Stat NULL_STAT = NullStat.me;
    public static final Stat[] NULL_STAT_ARRAY = new Stat[0];
    private Stat[] statArray;

    public StatList(List<Stat> statList) {
        this.statArray = statList.size() > 0 ? statList.toArray(new Stat[statList.size()]) : NULL_STAT_ARRAY;
    }

    public Stat getActualStat() {
        if (this.statArray.length > 1) {
            return this;
        }
        if (this.statArray.length == 1) {
            return this.statArray[0];
        }
        return NULL_STAT;
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        Ctrl ctrl = scope.getCtrl();
        for (int i = 0; i < this.statArray.length && !ctrl.isJump(); ++i) {
            this.statArray[i].exec(env, scope, writer);
        }
    }

    public int length() {
        return this.statArray.length;
    }

    public Stat getStat(int index) {
        if (index < 0 || index >= this.statArray.length) {
            throw new TemplateException("Index out of bounds: index = " + index + ", length = " + this.statArray.length, this.location);
        }
        return this.statArray[index];
    }
}

