/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.undertow;

import com.ydn.jsrv.boot.JSrvBooter;
import com.ydn.jsrv.plugin.monitor.active.ActiveFactory;
import com.ydn.jsrv.undertow.UndertowConfig;
import com.ydn.jsrv.undertow.UndertowKit;
import com.ydn.jsrv.undertow.WebBuilder;
import com.ydn.jsrv.undertow.handler.HttpDisableHandler;
import com.ydn.jsrv.undertow.handler.HttpToHttpsHandler;
import com.ydn.jsrv.undertow.hotswap.HotSwapWatcher;
import com.ydn.jsrv.undertow.session.HotSwapSessionManagerFactory;
import com.ydn.jsrv.undertow.session.HotSwapSessionPersistenceManager;
import com.ydn.jsrv.undertow.ssl.SslBuilder;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.Version;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.SetHeaderHandler;
import io.undertow.server.handlers.encoding.ContentEncodingProvider;
import io.undertow.server.handlers.encoding.ContentEncodingRepository;
import io.undertow.server.handlers.encoding.EncodingHandler;
import io.undertow.server.handlers.encoding.GzipEncodingProvider;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.SessionManagerFactory;
import io.undertow.servlet.api.SessionPersistenceManager;
import java.text.DecimalFormat;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.ServletException;

public class UndertowServer {
    protected UndertowConfig config;
    protected DeploymentInfo deploymentInfo;
    protected DeploymentManager deploymentManager;
    protected Undertow.Builder builder;
    protected Undertow undertow;
    protected volatile boolean started = false;
    protected volatile HotSwapWatcher hotSwapWatcher;
    protected DecimalFormat decimalFormat = new DecimalFormat("#.#");
    protected Consumer<WebBuilder> webBuilder;
    protected BiConsumer<ClassLoader, DeploymentInfo> onDeployConsumer;
    protected Consumer<Undertow.Builder> onStartConsumer;

    public static void start(Class<? extends JSrvBooter> booter) {
        UndertowServer.create(booter).start();
    }

    public static UndertowServer create(Class<? extends JSrvBooter> booter) {
        return new UndertowServer(new UndertowConfig(booter));
    }

    public static UndertowServer create(UndertowConfig undertowConfig) {
        return new UndertowServer(undertowConfig);
    }

    protected UndertowServer(UndertowConfig undertowConfig) {
        this.config = undertowConfig;
    }

    public synchronized void start() {
        try {
            ActiveFactory.me().sendStart();
            String msg = "Starting jsrv  -> http://" + this.config.getHost() + ":" + this.config.getPort();
            if (this.config.isSslEnable()) {
                msg = msg + ", https://" + this.config.getHost() + ":" + this.config.getSslConfig().getPort();
            }
            System.out.println(msg);
            System.out.println("Info: undertow " + Version.getVersionString() + ", jvm " + System.getProperty("java.version"));
            long start = System.currentTimeMillis();
            this.doStart();
            System.out.println("Starting Complete in " + this.getTimeSpent(start) + " seconds. \n");
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    UndertowServer.this.stop();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            this.stopSilently();
            System.exit(1);
        }
    }

    protected boolean notBlank(String str) {
        return str != null && !"".equals(str.trim());
    }

    protected void doStart() {
        if (this.started) {
            return;
        }
        if (UndertowKit.isDeployMode()) {
            UndertowConfig.devMode = false;
        }
        this.init();
        if (this.onDeployConsumer != null) {
            this.onDeployConsumer.accept(this.config.getClassLoader(), this.deploymentInfo);
        }
        if (UndertowKit.notAvailablePort(this.config.getPort())) {
            throw new IllegalStateException("port: " + this.config.getPort() + " not available!\n");
        }
        this.deploymentManager = Servlets.defaultContainer().addDeployment(this.deploymentInfo);
        this.deploymentManager.deploy();
        this.configHttp();
        if (this.onStartConsumer != null) {
            this.onStartConsumer.accept(this.builder);
        }
        this.undertow = this.builder.build();
        this.undertow.start();
        if (this.isDevMode() && this.hotSwapWatcher == null) {
            this.hotSwapWatcher = new HotSwapWatcher(this);
            this.hotSwapWatcher.start();
        }
        this.started = true;
    }

    protected void configHttp() {
        HttpHandler httpHandler = null;
        try {
            httpHandler = this.deploymentManager.start();
        }
        catch (ServletException e) {
            this.stopSilently();
            throw new RuntimeException(e);
        }
        PathHandler pathHandler = Handlers.path().addPrefixPath(this.config.getContextPath(), httpHandler);
        pathHandler = this.configHandler((HttpHandler)pathHandler);
        pathHandler = this.configGzip((HttpHandler)pathHandler);
        pathHandler = new SetHeaderHandler((HttpHandler)pathHandler, "Manager", "jsrv");
        pathHandler = this.configSsl((HttpHandler)pathHandler);
        this.builder.addHttpListener(this.config.getPort(), this.config.getHost()).setHandler((HttpHandler)pathHandler);
    }

    protected HttpHandler configSsl(HttpHandler httpHandler) {
        if (this.config.isSslEnable()) {
            new SslBuilder(this.builder, this.config).build();
            if (this.config.isHttpToHttps()) {
                httpHandler = new HttpToHttpsHandler(httpHandler, this.config);
            } else if (this.config.isHttpDisable()) {
                httpHandler = new HttpDisableHandler(httpHandler);
            }
        } else if (this.config.isHttpToHttps()) {
            System.err.println("http redirect to https needs ssl support");
        }
        return httpHandler;
    }

    protected HttpHandler configHandler(HttpHandler next) {
        return next;
    }

    protected HttpHandler configGzip(HttpHandler pathHandler) {
        if (this.config.isGzipEnable()) {
            ContentEncodingRepository repository = new ContentEncodingRepository();
            GzipEncodingProvider provider = new GzipEncodingProvider(this.config.getGzipLevel());
            int minLength = this.config.getGzipMinLength();
            Predicate predicate = minLength > 0 ? Predicates.maxContentSize((long)minLength) : Predicates.truePredicate();
            repository.addEncodingHandler("gzip", (ContentEncodingProvider)provider, 100, predicate);
            return new EncodingHandler(pathHandler, repository);
        }
        return pathHandler;
    }

    protected void init() {
        this.builder = Undertow.builder();
        this.configjsrvPathKit();
        this.configUndertow();
        this.configWeb();
        this.configJSrvFilter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        System.out.println("\nShutdown Undertow Manager ......");
        long start = System.currentTimeMillis();
        try {
            if (this.hotSwapWatcher != null) {
                this.hotSwapWatcher.exit();
            }
            this.doStop();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.stopSilently();
        }
        finally {
            System.out.println("Shutdown Complete in " + this.getTimeSpent(start) + " seconds. See you later (^_^)\n");
        }
    }

    protected void doStop() throws ServletException {
        this.deploymentManager.stop();
        this.undertow.stop();
    }

    public synchronized void restart() {
        if (!this.started) {
            return;
        }
        this.started = false;
        try {
            System.err.println("\nLoading changes ......");
            long start = System.currentTimeMillis();
            this.doStop();
            this.config.replaceClassLoader();
            this.doStart();
            System.err.println("Loading complete in " + this.getTimeSpent(start) + " seconds (^_^)\n");
        }
        catch (Exception e) {
            System.err.println("Error restarting webapp after change in watched files");
            e.printStackTrace();
        }
    }

    protected String getTimeSpent(long startTime) {
        float timeSpent = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
        return this.decimalFormat.format(timeSpent);
    }

    protected void stopSilently() {
        try {
            this.started = false;
            if (this.undertow != null) {
                this.undertow.stop();
            }
        }
        catch (Exception e) {
            UndertowKit.doNothing(e);
        }
    }

    public UndertowServer onDeploy(BiConsumer<ClassLoader, DeploymentInfo> onDeployConsumer) {
        this.onDeployConsumer = onDeployConsumer;
        return this;
    }

    public UndertowServer onStart(Consumer<Undertow.Builder> onStartConsumer) {
        this.onStartConsumer = onStartConsumer;
        return this;
    }

    protected void configjsrvPathKit() {
        if (UndertowKit.isDeployMode()) {
            UndertowKit.configPathKit(this.config);
            return;
        }
    }

    protected void configUndertow() {
        this.builder.setServerOption(UndertowOptions.ALLOW_UNESCAPED_CHARACTERS_IN_URL, (Object)true);
        if (this.config.isSslEnable() && this.config.getHttp2Enable() != null && this.config.getHttp2Enable().booleanValue()) {
            this.builder.setServerOption(UndertowOptions.ENABLE_HTTP2, (Object)true);
        }
        if (this.config.getIoThreads() != null) {
            this.builder.setIoThreads(this.config.getIoThreads().intValue());
        }
        if (this.config.getWorkerThreads() != null) {
            this.builder.setWorkerThreads(this.config.getWorkerThreads().intValue());
        }
        this.deploymentInfo = Servlets.deployment();
        this.configSessionPersistenceManager();
        DeploymentInfo di = this.deploymentInfo;
        di.setResourceManager(this.config.getResourceManager());
        di.setClassLoader(this.config.getClassLoader());
        di.setContextPath(this.config.getContextPath());
        di.setDeploymentName("jsrv");
        di.setEagerFilterInit(true);
        if (this.config.getSessionTimeout() != null) {
            di.setDefaultSessionTimeout(this.config.getSessionTimeout().intValue());
        }
    }

    protected void configJSrvFilter() {
        this.deploymentInfo.addFilter(Servlets.filter((String)"jsrv", this.getJsrvFilter()).addInitParam("booterClass", this.config.getJSrvBooterClass())).addFilterUrlMapping("jsrv", "/*", DispatcherType.REQUEST);
    }

    private Class<? extends Filter> getJsrvFilter() {
        try {
            return this.config.getClassLoader().loadClass("com.ydn.jsrv.core.JSrvFilter");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected void configWeb() {
        if (this.webBuilder != null) {
            WebBuilder wb = new WebBuilder(this);
            this.webBuilder.accept(wb);
            if (wb.webSocketConfig != null) {
                wb.webSocketConfig.configWebSocket(this.deploymentInfo);
            }
        }
    }

    public UndertowServer configWeb(Consumer<WebBuilder> webBuilder) {
        this.webBuilder = webBuilder;
        return this;
    }

    protected void configSessionPersistenceManager() {
        if (this.config.getSessionHotSwap() && this.isDevMode()) {
            this.deploymentInfo.setSessionPersistenceManager((SessionPersistenceManager)new HotSwapSessionPersistenceManager(this.config));
            this.deploymentInfo.setSessionManagerFactory((SessionManagerFactory)HotSwapSessionManagerFactory.me);
        }
    }

    public UndertowConfig getUndertowConfig() {
        return this.config;
    }

    public boolean isDevMode() {
        return UndertowConfig.isDevMode();
    }

    public boolean isStarted() {
        return this.started;
    }

    public UndertowServer addHotSwapClassPrefix(String prefix) {
        this.config.addHotSwapClassPrefix(prefix);
        return this;
    }

    public UndertowServer addSystemClassPrefix(String prefix) {
        this.config.addSystemClassPrefix(prefix);
        return this;
    }
}

