/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.undertow.session;

import com.ydn.jsrv.undertow.UndertowConfig;
import com.ydn.jsrv.undertow.session.HotSwapObjectInputStream;
import io.undertow.servlet.UndertowServletLogger;
import io.undertow.servlet.api.SessionPersistenceManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HotSwapSessionPersistenceManager
implements SessionPersistenceManager {
    private static final Map<String, Map<String, SessionEntry>> data = new ConcurrentHashMap<String, Map<String, SessionEntry>>();
    private UndertowConfig undertowConfig;

    public HotSwapSessionPersistenceManager(UndertowConfig undertowConfig) {
        this.undertowConfig = undertowConfig;
    }

    public void persistSessions(String deploymentName, Map<String, SessionPersistenceManager.PersistentSession> sessionData) {
        try {
            HashMap<String, SessionEntry> serializedData = new HashMap<String, SessionEntry>();
            for (Map.Entry<String, SessionPersistenceManager.PersistentSession> sessionEntry : sessionData.entrySet()) {
                HashMap data = new HashMap();
                for (Map.Entry sessionAttribute : sessionEntry.getValue().getSessionData().entrySet()) {
                    try {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream(out);
                        objectOutputStream.writeObject(sessionAttribute.getValue());
                        objectOutputStream.close();
                        data.put(sessionAttribute.getKey(), out.toByteArray());
                    }
                    catch (Exception e) {
                        UndertowServletLogger.ROOT_LOGGER.failedToPersistSessionAttribute((String)sessionAttribute.getKey(), sessionAttribute.getValue(), sessionEntry.getKey(), e);
                    }
                }
                serializedData.put(sessionEntry.getKey(), new SessionEntry(sessionEntry.getValue().getExpiration(), data));
            }
            data.put(deploymentName, serializedData);
        }
        catch (Exception e) {
            UndertowServletLogger.ROOT_LOGGER.failedToPersistSessions(e);
        }
    }

    public Map<String, SessionPersistenceManager.PersistentSession> loadSessionAttributes(String deploymentName, ClassLoader classLoader) {
        try {
            long time = System.currentTimeMillis();
            Map<String, SessionEntry> data = HotSwapSessionPersistenceManager.data.remove(deploymentName);
            if (data != null) {
                HashMap<String, SessionPersistenceManager.PersistentSession> ret = new HashMap<String, SessionPersistenceManager.PersistentSession>();
                for (Map.Entry<String, SessionEntry> sessionEntry : data.entrySet()) {
                    if (sessionEntry.getValue().expiry.getTime() <= time) continue;
                    HashMap session = new HashMap();
                    for (Map.Entry sessionAttribute : sessionEntry.getValue().data.entrySet()) {
                        ClassLoader cl = this.undertowConfig.getClassLoader();
                        HotSwapObjectInputStream in = new HotSwapObjectInputStream(new ByteArrayInputStream((byte[])sessionAttribute.getValue()), cl);
                        session.put(sessionAttribute.getKey(), in.readObject());
                    }
                    ret.put(sessionEntry.getKey(), new SessionPersistenceManager.PersistentSession(sessionEntry.getValue().expiry, session));
                }
                return ret;
            }
        }
        catch (Exception e) {
            UndertowServletLogger.ROOT_LOGGER.failedtoLoadPersistentSessions(e);
        }
        return null;
    }

    public void clear(String deploymentName) {
    }

    static final class SessionEntry {
        private final Date expiry;
        private final Map<String, byte[]> data;

        private SessionEntry(Date expiry, Map<String, byte[]> data) {
            this.expiry = expiry;
            this.data = data;
        }
    }
}

