/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.util;

import com.ydn.jsrv.exception.RenderException;
import com.ydn.jsrv.render.RenderManager;
import com.ydn.jsrv.util.Ret;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HandlerUtil {
    protected static final RenderManager renderManager = RenderManager.me();

    public static void redirect(String url, HttpServletRequest request, HttpServletResponse response) {
        String queryString = request.getQueryString();
        if (queryString != null) {
            url = url.indexOf(63) == -1 ? url + "?" + queryString : url + "&" + queryString;
        }
        try {
            response.sendRedirect(url);
        }
        catch (IOException e) {
            throw new RenderException(e);
        }
    }

    public static void render(HttpServletRequest request, HttpServletResponse response, Map map) {
        renderManager.getRenderFactory().getJsonRender(Ret.ok(map)).setContext(request, response).render();
    }

    public static void render(HttpServletRequest request, HttpServletResponse response, List list) {
        renderManager.getRenderFactory().getJsonRender(Ret.ok(list)).setContext(request, response).render();
    }

    public static void render(HttpServletRequest request, HttpServletResponse response, String text) {
        renderManager.getRenderFactory().getStringRender(text).setContext(request, response).render();
    }

    public static void render(HttpServletRequest request, HttpServletResponse response, int code) {
        renderManager.getRenderFactory().getErrorRender(code).setContext(request, response).render();
    }
}

