/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.util;

import com.ydn.jsrv.util.HashUtil;
import java.util.List;
import java.util.UUID;

public class StrUtil {
    public static String firstCharToLowerCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }

    public static String firstCharToUpperCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] - 32);
            return new String(arr);
        }
        return str;
    }

    public static boolean isBlank(String str) {
        if (str == null) {
            return true;
        }
        int len = str.length();
        if (len == 0) {
            return true;
        }
        block3: for (int i = 0; i < len; ++i) {
            switch (str.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !StrUtil.isBlank(str);
    }

    public static boolean notBlank(String str) {
        return !StrUtil.isBlank(str);
    }

    public static boolean notBlank(String ... strings) {
        if (strings == null || strings.length == 0) {
            return false;
        }
        for (String str : strings) {
            if (!StrUtil.isBlank(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean notNull(Object ... paras) {
        if (paras == null) {
            return false;
        }
        for (Object obj : paras) {
            if (obj != null) continue;
            return false;
        }
        return true;
    }

    public static String defaultIfBlank(String str, String defaultValue) {
        return StrUtil.isBlank(str) ? defaultValue : str;
    }

    public static String toCamelCase(String stringWithUnderline) {
        if (stringWithUnderline.indexOf(95) == -1) {
            return stringWithUnderline;
        }
        stringWithUnderline = stringWithUnderline.toLowerCase();
        char[] fromArray = stringWithUnderline.toCharArray();
        char[] toArray = new char[fromArray.length];
        int j = 0;
        for (int i = 0; i < fromArray.length; ++i) {
            if (fromArray[i] == '_') {
                if (++i >= fromArray.length) continue;
                toArray[j++] = Character.toUpperCase(fromArray[i]);
                continue;
            }
            toArray[j++] = fromArray[i];
        }
        return new String(toArray, 0, j);
    }

    public static String join(String[] stringArray) {
        StringBuilder sb = new StringBuilder();
        for (String s : stringArray) {
            sb.append(s);
        }
        return sb.toString();
    }

    public static String join(String[] stringArray, String separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(stringArray[i]);
        }
        return sb.toString();
    }

    public static String join(List<String> list, String separator) {
        StringBuilder sb = new StringBuilder();
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(list.get(i));
        }
        return sb.toString();
    }

    public static boolean slowEquals(String a, String b) {
        byte[] aBytes = a != null ? a.getBytes() : null;
        byte[] bBytes = b != null ? b.getBytes() : null;
        return HashUtil.slowEquals(aBytes, bBytes);
    }

    public static boolean equals(String a, String b) {
        return a == null ? b == null : a.equals(b);
    }

    public static String getRandomUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String substringBefore(String str, String separator) {
        if (!StrUtil.isBlank(str) && separator != null) {
            if (separator.isEmpty()) {
                return "";
            }
            int pos = str.indexOf(separator);
            return pos == -1 ? str : str.substring(0, pos);
        }
        return str;
    }

    public static String substringAfter(String str, String separator) {
        if (StrUtil.isBlank(str)) {
            return str;
        }
        if (separator == null) {
            return "";
        }
        int pos = str.indexOf(separator);
        return pos == -1 ? "" : str.substring(pos + separator.length());
    }

    public static String leftPad(String str, int size, String padStr) {
        if (str == null) {
            return null;
        }
        if (StrUtil.isBlank(padStr)) {
            padStr = " ";
        }
        int padLen = padStr.length();
        int strLen = str.length();
        int pads = size - strLen;
        if (pads <= 0) {
            return str;
        }
        if (padLen == 1 && pads <= 8192) {
            return StrUtil.leftPad(str, size, String.valueOf(padStr.charAt(0)));
        }
        if (pads == padLen) {
            return padStr.concat(str);
        }
        if (pads < padLen) {
            return padStr.substring(0, pads).concat(str);
        }
        char[] padding = new char[pads];
        char[] padChars = padStr.toCharArray();
        for (int i = 0; i < pads; ++i) {
            padding[i] = padChars[i % padLen];
        }
        return new String(padding).concat(str);
    }

    public static boolean isNumeric(CharSequence cs) {
        if (StrUtil.isBlank(cs)) {
            return false;
        }
        int sz = cs.length();
        for (int i = 0; i < sz; ++i) {
            if (Character.isDigit(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isBlank(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }
}

