/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.util;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

public class SystemUtils {
    public static String[] getAllIps() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            HashSet<String> ipList = new HashSet<String>();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enAddr = intf.getInetAddresses();
                while (enAddr.hasMoreElements()) {
                    InetAddress addr = enAddr.nextElement();
                    ipList.add(addr.getHostAddress());
                }
            }
            return ipList.toArray(new String[0]);
        }
        catch (SocketException e) {
            return new String[0];
        }
    }

    public static String getCurrentPath() {
        File directory = new File("");
        try {
            return directory.getAbsolutePath();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getHostName() {
        InetAddress a;
        try {
            a = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            return "Unknow";
        }
        return a.getHostName();
    }

    public static List<String> getInputArgument() {
        RuntimeMXBean rbean = ManagementFactory.getRuntimeMXBean();
        return rbean.getInputArguments();
    }

    public static String getInputArgumentString() {
        List<String> ls = SystemUtils.getInputArgument();
        StringBuilder sb = new StringBuilder();
        for (String s : ls) {
            sb.append(s).append(" ");
        }
        return sb.toString();
    }

    public static String getLocalIp() {
        try {
            InetAddress address = InetAddress.getLocalHost();
            NetworkInterface ni = NetworkInterface.getByInetAddress(address);
            ni.getInetAddresses().nextElement().getAddress();
            String sIP = address.getHostAddress();
            return sIP;
        }
        catch (UnknownHostException e) {
            return "0.0.0.0";
        }
        catch (SocketException e) {
            return "0.0.0.0";
        }
    }

    public static String getLocalMac() {
        try {
            InetAddress address = InetAddress.getLocalHost();
            NetworkInterface ni = NetworkInterface.getByInetAddress(address);
            ni.getInetAddresses().nextElement().getAddress();
            byte[] mac = ni.getHardwareAddress();
            String sMAC = "";
            Formatter formatter = new Formatter();
            for (int i = 0; i < mac.length; ++i) {
                sMAC = formatter.format(Locale.getDefault(), "%02X%s", mac[i], i < mac.length - 1 ? "-" : "").toString();
            }
            formatter.close();
            return sMAC;
        }
        catch (UnknownHostException e) {
            return "00-00-00-00-00-00";
        }
        catch (SocketException e) {
            return "00-00-00-00-00-00";
        }
    }

    public static String getMainClass() {
        Exception e = new Exception();
        StackTraceElement[] tes = e.getStackTrace();
        return tes[tes.length - 1].getClassName();
    }

    public static String getOsUser() {
        Properties prop = System.getProperties();
        return prop.getProperty("user.name");
    }

    public static boolean isWindows() {
        Properties prop = System.getProperties();
        String os = prop.getProperty("os.name");
        return os.startsWith("win") || os.startsWith("Win");
    }
}

