/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.core;

import com.ydn.jsrv.annotation.RequestMapping;
import com.ydn.jsrv.core.Action;
import com.ydn.jsrv.core.Controller;
import com.ydn.jsrv.core.ControllerFactory;
import com.ydn.jsrv.exception.ActionException;
import com.ydn.jsrv.interceptor.Interceptor;
import com.ydn.jsrv.interceptor.InterceptorManager;
import com.ydn.jsrv.route.Routes;
import com.ydn.jsrv.util.ClassUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActionMapping {
    protected Routes routes;
    protected Map<String, Action> mapping = new HashMap<String, Action>(2048, 0.5f);
    protected Map<String, String> indexMap = new HashMap<String, String>();
    protected ControllerFactory controllerFactory = new ControllerFactory();
    protected String index;

    protected ActionMapping(Routes routes) {
        this.routes = routes;
    }

    protected List<Routes> getRoutesList() {
        List<Routes> routesList = Routes.getRoutesList();
        ArrayList<Routes> ret = new ArrayList<Routes>(routesList.size() + 1);
        ret.add(this.routes);
        ret.addAll(routesList);
        return ret;
    }

    public void buildActionMapping() {
        this.mapping.clear();
        this.iniIndexMap();
        for (Routes routes : this.getRoutesList()) {
            for (Routes.Route route : routes.getRouteItemList()) {
                this.findController(route, routes.getInterceptors());
            }
        }
        this.routes.clear();
    }

    protected void iniIndexMap() {
        this.indexMap.putAll(Routes.getIndexList());
    }

    private void findController(Routes.Route route, Interceptor[] interceptors) {
        String pkg = route.getRoutePkg();
        String[] ps = pkg.split(";");
        Action action = null;
        Interceptor[] actionInters = null;
        String serviceName = null;
        Method[] methods = null;
        InterceptorManager interMan = InterceptorManager.me();
        Interceptor[] controllerInters = null;
        String target = "";
        for (String p : ps) {
            try {
                List<Class<Controller>> clazzs = ClassUtils.findClasses(Controller.class, p);
                for (Class<Controller> clazz : clazzs) {
                    controllerInters = interMan.createControllerInterceptor(clazz);
                    for (Method method : methods = clazz.getMethods()) {
                        if (!method.isAnnotationPresent(RequestMapping.class)) continue;
                        actionInters = interMan.buildControllerActionInterceptor(interceptors, controllerInters, clazz, method);
                        serviceName = method.getAnnotation(RequestMapping.class).value();
                        if (!serviceName.startsWith("/")) {
                            serviceName = "/" + serviceName;
                        }
                        if (this.mapping.get(target = route.getRouteKey() + serviceName) != null) {
                            throw new ActionException(501, this.buildMsg(target, clazz, method));
                        }
                        action = new Action(method.getAnnotation(RequestMapping.class), target, clazz, method.getName(), method, actionInters);
                        this.mapping.put(target, action);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("\nException: " + e.fillInStackTrace());
                throw new RuntimeException(e);
            }
        }
    }

    protected String buildMsg(String actionKey, Class<? extends Controller> controllerClass, Method method) {
        StringBuilder sb = new StringBuilder("The action \"").append(controllerClass.getName()).append(".").append(method.getName()).append("()\" can not be mapped, ").append("actionKey \"").append(actionKey).append("\" is already in use.");
        return sb.toString();
    }

    public Action getAction(String target) {
        return this.mapping.get(target);
    }

    public String getIndexHtml(String key) {
        return this.indexMap.get(key);
    }

    public List<Action> getAllAction() {
        ArrayList<Action> allAction = new ArrayList<Action>(this.mapping.values());
        return allAction;
    }

    public List<Map<String, String>> getAllActionKeys() {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        ArrayList<String> allActionKeys = new ArrayList<String>(this.mapping.keySet());
        Collections.sort(allActionKeys);
        HashMap<String, String> map = null;
        for (String actionKey : allActionKeys) {
            map = new HashMap<String, String>();
            map.put("path", actionKey);
            map.put("name", this.mapping.get(actionKey).getActionName());
            list.add(map);
        }
        return list;
    }
}

