/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.core;

import com.alibaba.fastjson.JSON;
import com.oreilly.servlet.MultipartRequest;
import com.ydn.jsrv.annotation.RequestMethod;
import com.ydn.jsrv.core.Action;
import com.ydn.jsrv.core.Injector;
import com.ydn.jsrv.exception.ActionException;
import com.ydn.jsrv.render.Render;
import com.ydn.jsrv.render.RenderManager;
import com.ydn.jsrv.tool.captcha.CaptchaRender;
import com.ydn.jsrv.tool.upload.MultiRequest;
import com.ydn.jsrv.tool.upload.UploadFile;
import com.ydn.jsrv.util.HttpUtil;
import com.ydn.jsrv.util.MapTools;
import com.ydn.jsrv.util.Ret;
import com.ydn.jsrv.util.StrUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public abstract class Controller {
    private Action action;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private Render render;
    private static final RenderManager renderManager = RenderManager.me();
    private String postParam;
    private Map paramMap;
    private List<UploadFile> uploadFiles;

    public void init(Action action, HttpServletRequest request, HttpServletResponse response) {
        this.action = action;
        this.request = request;
        this.response = response;
        this.render = null;
        this.paramMap = null;
        this.postParam = null;
    }

    protected void _clear_() {
        this.action = null;
        this.request = null;
        this.response = null;
        this.render = null;
        this.paramMap = null;
        this.postParam = null;
    }

    public String getPostParam() {
        if (this.postParam == null) {
            this.postParam = HttpUtil.readData(this.request);
        }
        return this.postParam;
    }

    public Map getParamMap() {
        if (this.paramMap == null) {
            try {
                this.postParam = HttpUtil.readData(this.request);
                this.paramMap = this.parsePostParam(Map.class);
            }
            catch (Exception e) {
                this.paramMap = new HashMap();
            }
        }
        return this.paramMap;
    }

    public void putParamMap(Map map) {
        this.getParamMap().putAll(map);
    }

    public <T> T parsePostParam(Class<T> type) {
        return (T)JSON.parseObject((String)this.getPostParam(), type);
    }

    public String getPara(String name) {
        String value = this.request.getParameter(name);
        if (StrUtil.isBlank(value)) {
            return MapTools.getString(this.getParamMap(), name);
        }
        return value;
    }

    public boolean isPost() {
        return RequestMethod.POST.name().equals(this.request.getMethod());
    }

    public String getPara(String name, String defaultValue) {
        String result = this.getPara(name);
        return result != null && !"".equals(result) ? result : defaultValue;
    }

    public Integer getParaToInt(String name) {
        return this.toInt(this.getPara(name), null);
    }

    public Integer getParaToInt(String name, Integer defaultValue) {
        return this.toInt(this.getPara(name), defaultValue);
    }

    public Long getParaToLong(String name) {
        return this.toLong(this.getPara(name), null);
    }

    public Long getParaToLong(String name, Long defaultValue) {
        return this.toLong(this.getPara(name), defaultValue);
    }

    private Integer toInt(String value, Integer defaultValue) {
        try {
            if (StrUtil.isBlank(value)) {
                return defaultValue;
            }
            if ((value = value.trim()).startsWith("N") || value.startsWith("n")) {
                return -Integer.parseInt(value.substring(1));
            }
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            throw new ActionException(400, "Can not parse the parameter \"" + value + "\" to Integer value.");
        }
    }

    protected Long toLong(String value, Long defaultValue) {
        try {
            if (StrUtil.isBlank(value)) {
                return defaultValue;
            }
            return !(value = value.trim()).startsWith("N") && !value.startsWith("n") ? Long.parseLong(value) : -Long.parseLong(value.substring(1));
        }
        catch (Exception var4) {
            throw new ActionException(400, "Can not parse the parameter \"" + value + "\" to Long value.");
        }
    }

    protected Long toLong(String value) {
        try {
            if (StrUtil.isBlank(value)) {
                return null;
            }
            return !(value = value.trim()).startsWith("N") && !value.startsWith("n") ? Long.parseLong(value) : -Long.parseLong(value.substring(1));
        }
        catch (Exception var4) {
            throw new ActionException(400, "Can not parse the parameter \"" + value + "\" to Long value.");
        }
    }

    public Boolean getParaToBoolean(String name, Boolean defaultValue) {
        return this.toBoolean(this.getPara(name), defaultValue);
    }

    private Boolean toBoolean(String value, Boolean defaultValue) {
        if (StrUtil.isBlank(value)) {
            return defaultValue;
        }
        if (!"1".equals(value = value.trim().toLowerCase()) && !"true".equals(value)) {
            if (!"0".equals(value) && !"false".equals(value)) {
                throw new ActionException(400, "Can not parse the parameter \"" + value + "\" to Boolean value.");
            }
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Controller setAttr(String name, Object value) {
        this.request.setAttribute(name, value);
        return this;
    }

    public Controller removeAttr(String name) {
        this.request.removeAttribute(name);
        return this;
    }

    public <T> T getAttr(String name) {
        return (T)this.request.getAttribute(name);
    }

    public Controller setCookie(String name, String value, int maxAgeInSeconds, boolean isHttpOnly) {
        return this.doSetCookie(name, value, maxAgeInSeconds, null, null, isHttpOnly);
    }

    public String getCookie(String name, String defaultValue) {
        Cookie cookie = this.getCookieObject(name);
        return cookie != null ? cookie.getValue() : defaultValue;
    }

    public String getCookie(String name) {
        return this.getCookie(name, null);
    }

    public Cookie getCookieObject(String name) {
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie;
            }
        }
        return null;
    }

    public Controller removeCookie(String name) {
        return this.doSetCookie(name, null, 0, null, null, null);
    }

    private Controller doSetCookie(String name, String value, int maxAgeInSeconds, String path, String domain, Boolean isHttpOnly) {
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(maxAgeInSeconds);
        if (path == null) {
            path = "/";
        }
        cookie.setPath(path);
        if (domain != null) {
            cookie.setDomain(domain);
        }
        if (isHttpOnly != null) {
            cookie.setHttpOnly(isHttpOnly.booleanValue());
        }
        this.response.addCookie(cookie);
        return this;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public HttpSession getSession(boolean create) {
        return this.request.getSession(create);
    }

    public <T> T getSessionAttr(String key) {
        HttpSession session = this.request.getSession(false);
        return (T)(session != null ? session.getAttribute(key) : null);
    }

    public <T> T getSessionAttr(String key, T defaultValue) {
        T result = this.getSessionAttr(key);
        return result != null ? result : defaultValue;
    }

    public Controller setSessionAttr(String key, Object value) {
        this.request.getSession(true).setAttribute(key, value);
        return this;
    }

    public Controller removeSessionAttr(String key) {
        HttpSession session = this.request.getSession(false);
        if (session != null) {
            session.removeAttribute(key);
        }
        return this;
    }

    public <T> T getBean(Class<T> beanClass) {
        if (this.isPost()) {
            return (T)JSON.parseObject((String)this.getPostParam(), beanClass);
        }
        return Injector.injectBean(beanClass, this.request, false);
    }

    public boolean validateCaptcha(String paraName) {
        return CaptchaRender.validate(this, this.getPara(paraName));
    }

    public void renderCaptcha() {
        this.render = renderManager.getRenderFactory().getCaptchaRender();
    }

    public UploadFile getFile(String parameterName, String uploadPath) {
        this.getFiles(uploadPath);
        return this.getFile(parameterName);
    }

    public UploadFile getFile(String parameterName) {
        List<UploadFile> uploadFiles = this.getFiles();
        for (UploadFile uploadFile : uploadFiles) {
            if (!uploadFile.getParameterName().equals(parameterName)) continue;
            return uploadFile;
        }
        return null;
    }

    public List<UploadFile> getFiles(String uploadPath) {
        if (!(this.request instanceof MultipartRequest)) {
            this.request = new MultiRequest(this.request, uploadPath);
        }
        return ((MultiRequest)this.request).getFiles();
    }

    public List<UploadFile> getFiles() {
        if (!(this.request instanceof MultiRequest)) {
            this.request = new MultiRequest(this.request);
        }
        return ((MultiRequest)this.request).getFiles();
    }

    public Render getRender() {
        if (this.render == null) {
            this.render = renderManager.getRenderFactory().getJsonRender(Ret.ok());
        }
        return this.render;
    }

    public void renderJson(Ret ret) {
        this.render = renderManager.getRenderFactory().getJsonRender(ret);
    }

    public void renderTemplate(String view) {
        this.render = renderManager.getRenderFactory().getTemplateRender(view);
    }

    public Action getAction() {
        return this.action;
    }
}

