/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.doc;

import com.alibaba.fastjson.JSON;
import com.ydn.jsrv.annotation.ApiModelProperty;
import com.ydn.jsrv.annotation.RequestMapping;
import com.ydn.jsrv.annotation.RequestParam;
import com.ydn.jsrv.annotation.ResponseItem;
import com.ydn.jsrv.annotation.ResponseRet;
import com.ydn.jsrv.annotation.ResponseType;
import com.ydn.jsrv.core.Action;
import com.ydn.jsrv.core.ActionMapping;
import com.ydn.jsrv.core.JSrv;
import com.ydn.jsrv.handler.Handler;
import com.ydn.jsrv.plugin.activerecord.Model;
import com.ydn.jsrv.util.HandlerUtil;
import com.ydn.jsrv.util.Ret;
import com.ydn.jsrv.util.StrUtil;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DocHandler
extends Handler {
    private String url;
    private static final JSrv jsrv = JSrv.me();

    protected DocHandler(String url) {
        if (StrUtil.isBlank(url)) {
            throw new IllegalArgumentException("visitPath can not be blank");
        }
        if (!(url = url.trim()).startsWith("/")) {
            url = "/" + url;
        }
        this.url = url;
    }

    @Override
    public void handle(String target, HttpServletRequest request, HttpServletResponse response, boolean[] isHandled) {
        if (target.startsWith(this.url)) {
            isHandled[0] = true;
            ActionMapping actionMapping = jsrv.getActionMapping();
            if (target.equals(this.url)) {
                List<Map<String, String>> allActionKey = actionMapping.getAllActionKeys();
                HandlerUtil.render(request, response, JSON.toJSONString(allActionKey));
            } else {
                Action action = actionMapping.getAction(target = target.substring(this.url.length()));
                if (action == null) {
                    HandlerUtil.render(request, response, 404);
                    return;
                }
                RequestMapping requestMapping = action.getRequestMapping();
                HandlerUtil.render(request, response, JSON.toJSONString((Object)this.parseRequestMapping(requestMapping)));
            }
        } else {
            this.next.handle(target, request, response, isHandled);
        }
    }

    private Map parseRequestMapping(RequestMapping requestMapping) {
        HashMap<String, Object> mappingMap = new HashMap<String, Object>();
        mappingMap.put("name", requestMapping.name());
        mappingMap.put("method", requestMapping.method().name());
        RequestParam[] params = requestMapping.params();
        ArrayList paramsArr = new ArrayList();
        HashMap<String, Object> paramMap = null;
        if (params != null) {
            for (RequestParam requestParam : params) {
                paramMap = new HashMap<String, Object>();
                paramMap.put("code", requestParam.value());
                paramMap.put("name", requestParam.name());
                paramMap.put("type", requestParam.type().name());
                paramMap.put("desc", requestParam.desc());
                paramMap.put("required", requestParam.required());
                paramsArr.add(paramMap);
            }
        }
        mappingMap.put("requestParam", paramsArr);
        mappingMap.put("responseRet", this.parseResponseRet(requestMapping.resp()));
        mappingMap.put("responseDemo", this.generatorResponseDemo(requestMapping.resp()));
        return mappingMap;
    }

    private Map generatorResponseDemo(ResponseRet responseRet) {
        if (ResponseType.NONE.equals((Object)responseRet.type())) {
            Ret ret = Ret.ok();
            return ret;
        }
        HashMap map = new HashMap();
        Class respClass = responseRet.clazz();
        this.generatorFieldsDemo(map, respClass);
        if (ResponseType.OBJECT.equals((Object)responseRet.type())) {
            return Ret.ok(map);
        }
        if (ResponseType.LIST.equals((Object)responseRet.type())) {
            ArrayList list = new ArrayList();
            list.add(map);
            return Ret.ok(list);
        }
        return null;
    }

    private void generatorFieldsDemo(Map map, Class clazz) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            System.out.println(field.getType());
            String varName = field.getName();
            if (field.getType() == String.class) {
                map.put(varName, "string");
                continue;
            }
            if ("int".equals(field.getType().getName()) || "long".equals(field.getType().getName()) || field.getType() == Integer.class || field.getType() == Long.class) {
                map.put(varName, 0);
                continue;
            }
            if (field.getType() == Date.class) {
                map.put(varName, new Date());
                continue;
            }
            if (field.getType() == Timestamp.class) {
                map.put(varName, new Date());
                continue;
            }
            if (field.getType() == Object.class) {
                map.put(varName, new HashMap());
                continue;
            }
            if (field.getType() == List.class) {
                map.put(varName, new ArrayList());
                continue;
            }
            if (field.getType() == Map.class) {
                map.put(varName, new HashMap());
                continue;
            }
            if ("boolean".equals(field.getType().getName()) || field.getType() == Double.class) {
                map.put(varName, false);
                continue;
            }
            if (!"double".equals(field.getType().getName()) && !"float".equals(field.getType().getName()) && field.getType() != Double.class && field.getType() != Float.class) continue;
            map.put(varName, 0.0);
        }
    }

    private List<Map> parseResponseRet(ResponseRet responseRet) {
        ArrayList<Map> list = new ArrayList<Map>();
        HashMap<String, String> errorCodeMap = new HashMap<String, String>();
        errorCodeMap.put("name", "errcode");
        errorCodeMap.put("dataType", "String");
        errorCodeMap.put("desc", "0\u6210\u529f\uff0c1\u7cfb\u7edf\u9519\u8bef\uff0c2\u672a\u767b\u5f55\uff0c");
        list.add(errorCodeMap);
        HashMap<String, String> errorMsgMap = new HashMap<String, String>();
        errorMsgMap.put("name", "errmsg");
        errorMsgMap.put("dataType", "String");
        errorMsgMap.put("desc", "\u8fd4\u56de\u63d0\u793a\u4fe1\u606f\uff0c\u9ed8\u8ba4success");
        list.add(errorMsgMap);
        if (ResponseType.NONE.equals((Object)responseRet.type())) {
            return list;
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (ResponseType.OBJECT.equals((Object)responseRet.type())) {
            resultMap.put("name", "data");
            resultMap.put("dataType", "Object");
        }
        if (ResponseType.LIST.equals((Object)responseRet.type())) {
            resultMap.put("name", "list");
            resultMap.put("dataType", "Array");
        }
        Class respClass = responseRet.clazz();
        ResponseItem[] responseItems = responseRet.items();
        ArrayList<Map> fieldList = new ArrayList<Map>();
        this.parseFields(fieldList, respClass);
        this.parseFields(fieldList, responseItems);
        resultMap.put("children", fieldList);
        list.add(resultMap);
        return list;
    }

    private void parseFields(List<Map> fieldList, ResponseItem[] responseItems) {
        if (responseItems == null || responseItems.length == 0) {
            return;
        }
        HashMap<String, String> map = null;
        for (ResponseItem responseItem : responseItems) {
            map = new HashMap<String, String>();
            map.put("name", responseItem.key());
            map.put("dataType", responseItem.type().name());
            map.put("desc", responseItem.desc());
            fieldList.add(map);
        }
    }

    private void parseFields(List<Map> fieldList, Class clazz) {
        if (clazz.getName().equals(Void.class.getName())) {
            return;
        }
        Field[] fields = clazz.getDeclaredFields();
        HashMap<String, String> map = null;
        for (Field field : fields) {
            String varName = field.getName();
            if (field.getAnnotation(ApiModelProperty.class) == null) continue;
            map = new HashMap<String, String>();
            map.put("name", varName);
            map.put("dataType", field.getType().getName());
            map.put("desc", field.getAnnotation(ApiModelProperty.class).value());
            fieldList.add(map);
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Model.class) {
            this.parseFields(fieldList, superClass);
        }
    }
}

