/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.interceptor;

import com.ydn.jsrv.annotation.Before;
import com.ydn.jsrv.annotation.Clear;
import com.ydn.jsrv.aop.Aop;
import com.ydn.jsrv.core.Controller;
import com.ydn.jsrv.interceptor.Interceptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class InterceptorManager {
    public static final Interceptor[] NULL_INTERS = new Interceptor[0];
    private Interceptor[] globalActionInters = NULL_INTERS;
    private Interceptor[] globalServiceInters = NULL_INTERS;
    private final ConcurrentHashMap<Class<? extends Interceptor>, Interceptor> singletonMap = new ConcurrentHashMap(32, 0.5f);
    private final ConcurrentHashMap<Class<?>, Interceptor[]> serviceClassInters = new ConcurrentHashMap(32, 0.5f);
    private static final InterceptorManager me = new InterceptorManager();

    private InterceptorManager() {
    }

    public static InterceptorManager me() {
        return me;
    }

    public Interceptor[] createControllerInterceptor(Class<? extends Controller> controllerClass) {
        return this.createInterceptor(controllerClass.getAnnotation(Before.class));
    }

    public Interceptor[] createServiceInterceptor(Class<?> serviceClass) {
        Interceptor[] result = this.serviceClassInters.get(serviceClass);
        if (result == null) {
            result = this.createInterceptor(serviceClass.getAnnotation(Before.class));
            this.serviceClassInters.put(serviceClass, result);
        }
        return result;
    }

    public Interceptor[] buildControllerActionInterceptor(Interceptor[] routesInters, Interceptor[] classInters, Class<? extends Controller> controllerClass, Method method) {
        return this.doBuild(this.globalActionInters, routesInters, classInters, controllerClass, method);
    }

    public Interceptor[] buildServiceMethodInterceptor(Class<?> serviceClass, Method method) {
        return this.doBuild(this.globalServiceInters, NULL_INTERS, this.createServiceInterceptor(serviceClass), serviceClass, method);
    }

    private Interceptor[] doBuild(Interceptor[] globalInters, Interceptor[] routesInters, Interceptor[] classInters, Class<?> targetClass, Method method) {
        Class<? extends Interceptor>[] clearIntersOnClass;
        Clear clearOnClass;
        Class<? extends Interceptor>[] clearIntersOnMethod;
        Interceptor[] methodInters = this.createInterceptor(method.getAnnotation(Before.class));
        Clear clearOnMethod = method.getAnnotation(Clear.class);
        if (clearOnMethod != null) {
            clearIntersOnMethod = clearOnMethod.value();
            if (clearIntersOnMethod.length == 0) {
                return methodInters;
            }
        } else {
            clearIntersOnMethod = null;
        }
        if ((clearOnClass = targetClass.getAnnotation(Clear.class)) != null) {
            clearIntersOnClass = clearOnClass.value();
            if (clearIntersOnClass.length == 0) {
                globalInters = NULL_INTERS;
                routesInters = NULL_INTERS;
            }
        } else {
            clearIntersOnClass = null;
        }
        ArrayList<Interceptor> result = new ArrayList<Interceptor>(globalInters.length + routesInters.length + classInters.length + methodInters.length);
        for (Interceptor inter : globalInters) {
            result.add(inter);
        }
        for (Interceptor inter : routesInters) {
            result.add(inter);
        }
        if (clearIntersOnClass != null && clearIntersOnClass.length > 0) {
            this.removeInterceptor(result, clearIntersOnClass);
        }
        for (Interceptor inter : classInters) {
            result.add(inter);
        }
        if (clearIntersOnMethod != null && clearIntersOnMethod.length > 0) {
            this.removeInterceptor(result, clearIntersOnMethod);
        }
        for (Interceptor inter : methodInters) {
            result.add(inter);
        }
        return result.toArray(new Interceptor[result.size()]);
    }

    private void removeInterceptor(ArrayList<Interceptor> target, Class<? extends Interceptor>[] clearInters) {
        Iterator<Interceptor> it = target.iterator();
        block0: while (it.hasNext()) {
            Interceptor curInter = it.next();
            if (curInter != null) {
                Class<?> curInterClass = curInter.getClass();
                for (Class<? extends Interceptor> ci : clearInters) {
                    if (curInterClass != ci) continue;
                    it.remove();
                    continue block0;
                }
                continue;
            }
            it.remove();
        }
    }

    public Interceptor[] createInterceptor(Before beforeAnnotation) {
        if (beforeAnnotation == null) {
            return NULL_INTERS;
        }
        return this.createInterceptor(beforeAnnotation.value());
    }

    public Interceptor[] createInterceptor(Class<? extends Interceptor>[] interceptorClasses) {
        if (interceptorClasses == null || interceptorClasses.length == 0) {
            return NULL_INTERS;
        }
        Interceptor[] result = new Interceptor[interceptorClasses.length];
        try {
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.singletonMap.get(interceptorClasses[i]);
                if (result[i] != null) continue;
                result[i] = interceptorClasses[i].newInstance();
                Aop.inject(result[i]);
                this.singletonMap.put(interceptorClasses[i], result[i]);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addGlobalActionInterceptor(Interceptor ... inters) {
        this.addGlobalInterceptor(true, inters);
    }

    public void addGlobalServiceInterceptor(Interceptor ... inters) {
        this.addGlobalInterceptor(false, inters);
    }

    private synchronized void addGlobalInterceptor(boolean forAction, Interceptor ... inters) {
        if (inters == null || inters.length == 0) {
            throw new IllegalArgumentException("interceptors can not be null.");
        }
        for (Interceptor inter : inters) {
            if (inter == null) {
                throw new IllegalArgumentException("interceptor can not be null.");
            }
            if (!this.singletonMap.containsKey(inter.getClass())) continue;
            throw new IllegalArgumentException("interceptor already exists, interceptor must be singlton, do not create more then one instance of the same interceptor Class.");
        }
        for (Interceptor inter : inters) {
            Aop.inject(inter);
            this.singletonMap.put(inter.getClass(), inter);
        }
        Interceptor[] globalInters = forAction ? this.globalActionInters : this.globalServiceInters;
        Interceptor[] temp = new Interceptor[globalInters.length + inters.length];
        System.arraycopy(globalInters, 0, temp, 0, globalInters.length);
        System.arraycopy(inters, 0, temp, globalInters.length, inters.length);
        if (forAction) {
            this.globalActionInters = temp;
        } else {
            this.globalServiceInters = temp;
        }
    }

    public List<Class<?>> getGlobalServiceInterceptorClasses() {
        ArrayList ret = new ArrayList(this.globalServiceInters.length + 3);
        for (Interceptor i : this.globalServiceInters) {
            ret.add(i.getClass());
        }
        return ret;
    }
}

