/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.log;

import com.ydn.jsrv.log.ILogFactory;
import com.ydn.jsrv.log.JdkLogFactory;
import com.ydn.jsrv.log.Log4jLogFactory;

public abstract class Log {
    private static ILogFactory defaultLogFactory = null;

    static void init() {
        if (defaultLogFactory == null) {
            try {
                Class.forName("org.apache.log4j.Logger");
                defaultLogFactory = new Log4jLogFactory();
            }
            catch (Exception e) {
                defaultLogFactory = new JdkLogFactory();
            }
        }
    }

    static void setDefaultLogFactory(ILogFactory defaultLogFactory) {
        if (defaultLogFactory == null) {
            throw new IllegalArgumentException("defaultLogFactory can not be null.");
        }
        Log.defaultLogFactory = defaultLogFactory;
    }

    public static Log getLog(Class<?> clazz) {
        return defaultLogFactory.getLog(clazz);
    }

    public static Log getLog(String name) {
        return defaultLogFactory.getLog(name);
    }

    public abstract void debug(String var1);

    public abstract void debug(String var1, Throwable var2);

    public abstract void info(String var1);

    public abstract void info(String var1, Throwable var2);

    public abstract void warn(String var1);

    public abstract void warn(String var1, Throwable var2);

    public abstract void error(String var1);

    public abstract void error(String var1, Throwable var2);

    public abstract void fatal(String var1);

    public abstract void fatal(String var1, Throwable var2);

    public abstract boolean isDebugEnabled();

    public abstract boolean isInfoEnabled();

    public abstract boolean isWarnEnabled();

    public abstract boolean isErrorEnabled();

    public abstract boolean isFatalEnabled();

    static {
        Log.init();
    }
}

