/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.plugin.activerecord;

public class PageSqlKit {
    private static final int start = "select ".length();
    private static final char NULL = '\u0000';
    private static final char SIZE = '\u0080';
    private static char[] charTable = PageSqlKit.buildCharTable();

    private static char[] buildCharTable() {
        char[] ret = new char[128];
        for (int i = 0; i < 128; i = (int)((char)(i + 1))) {
            ret[i] = '\u0000';
        }
        ret[40] = 40;
        ret[41] = 41;
        ret[102] = 102;
        ret[70] = 102;
        ret[114] = 114;
        ret[82] = 114;
        ret[111] = 111;
        ret[79] = 111;
        ret[109] = 109;
        ret[77] = 109;
        ret[32] = 32;
        ret[13] = 32;
        ret[10] = 32;
        ret[9] = 32;
        return ret;
    }

    private static int getIndexOfFrom(String sql) {
        int parenDepth = 0;
        int end = sql.length() - 5;
        for (int i = start; i < end; ++i) {
            char c = sql.charAt(i);
            if (c >= '\u0080' || (c = charTable[c]) == '\u0000') continue;
            if (c == '(') {
                ++parenDepth;
                continue;
            }
            if (c == ')') {
                if (parenDepth == 0) {
                    throw new RuntimeException("Can not match left paren '(' for right paren ')': " + sql);
                }
                --parenDepth;
                continue;
            }
            if (parenDepth > 0 || c != 'f' || charTable[sql.charAt(i + 1)] != 'r' || charTable[sql.charAt(i + 2)] != 'o' || charTable[sql.charAt(i + 3)] != 'm' || charTable[c = sql.charAt(i + 4)] != ' ' && c != '(' || charTable[c = sql.charAt(i - 1)] != ' ' && c != ')') continue;
            return i;
        }
        return -1;
    }

    public static String[] parsePageSql(String sql) {
        int index = PageSqlKit.getIndexOfFrom(sql);
        if (index == -1) {
            return null;
        }
        String[] ret = new String[]{sql.substring(0, index), sql.substring(index)};
        return ret;
    }
}

