/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.plugin.activerecord.parse;

import com.ydn.jsrv.util.StrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SqlParse {
    private StringBuilder sqlstr = new StringBuilder(500);
    private Map param;
    private List<Object> params = new ArrayList<Object>();

    public SqlParse(Map param) {
        this.param = param;
    }

    private static final List<String> getTokens(String sql) {
        String paramName;
        boolean isInnerQuota = false;
        boolean isInnerParam = false;
        int begParam = -1;
        ArrayList<String> paramNames = new ArrayList<String>(20);
        int len = sql.length();
        for (int i = 0; i < len; ++i) {
            char c = sql.charAt(i);
            if ('\'' == c) {
                if (isInnerQuota) {
                    isInnerQuota = false;
                    continue;
                }
                isInnerQuota = true;
                continue;
            }
            if (isInnerQuota) continue;
            if (':' == c) {
                isInnerParam = true;
                begParam = i + 1;
                continue;
            }
            if (!isInnerParam || SqlParse.isVariableChar(c)) continue;
            isInnerParam = false;
            String paramName2 = sql.substring(begParam, i);
            if (!StrUtil.isBlank(paramName2)) {
                paramNames.add(paramName2);
            }
            begParam = -1;
        }
        if (-1 != begParam && !StrUtil.isBlank(paramName = sql.substring(begParam))) {
            paramNames.add(paramName);
        }
        return paramNames;
    }

    public final void addSQL(String sql) {
        List<String> names = SqlParse.getTokens(sql);
        if (names.isEmpty()) {
            this.sqlstr.append(sql);
            return;
        }
        String tmpName = null;
        ArrayList tmpParams = new ArrayList();
        for (String name : names) {
            Object value = this.param.get(name);
            if (null == value) {
                return;
            }
            if (value instanceof String && StrUtil.isBlank((String)value)) {
                return;
            }
            tmpName = ":" + name;
            sql = SqlParse.replace(sql, tmpName, "?");
            tmpParams.add(value);
        }
        this.params.addAll(tmpParams);
        this.sqlstr.append(sql);
    }

    public final void addLikeSQL(String sql) {
        List<String> names = SqlParse.getTokens(sql);
        if (names.isEmpty()) {
            this.sqlstr.append(sql);
            return;
        }
        String tmpName = "";
        for (String name : names) {
            Object value = this.param.get(name);
            if (null == value) {
                return;
            }
            if (!(value instanceof String) || !StrUtil.notBlank((String)value)) continue;
            tmpName = ":" + name;
            sql = SqlParse.replace(sql, tmpName, "?");
            this.params.add("%" + value + "%");
        }
        this.sqlstr.append(sql);
    }

    public final String getSQL() {
        return this.sqlstr.toString();
    }

    public final List<Object> getParams() {
        return this.params;
    }

    public final Object[] getParamsArray() {
        return this.params.toArray();
    }

    public final Map getParam() {
        return this.param;
    }

    public static final boolean isVariableChar(char c) {
        if ('0' <= c && c <= '9') {
            return true;
        }
        if ('A' <= c && c <= 'Z') {
            return true;
        }
        if ('a' <= c && c <= 'z') {
            return true;
        }
        return '_' == c;
    }

    public static String replace(String str, String source, String target) {
        if (StrUtil.isBlank(str)) {
            return str;
        }
        return str.replace(source, target);
    }
}

