/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.plugin.monitor;

import com.alibaba.fastjson.JSON;
import com.ydn.jsrv.plugin.monitor.Monitor;
import com.ydn.jsrv.plugin.monitor.MonitorDataMap;
import com.ydn.jsrv.plugin.monitor.service.MonitorService;
import com.ydn.jsrv.tool.concurrent.NamedThreadFactory;
import com.ydn.jsrv.util.DateUtil;
import com.ydn.jsrv.util.LogUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class JsrvMonitor
implements Monitor {
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(3, new NamedThreadFactory("JsrvMonitorSendTimer", true));
    private final ConcurrentMap<String, AtomicReference<long[]>> statisticsMap = new ConcurrentHashMap<String, AtomicReference<long[]>>();
    private final ScheduledFuture<?> sendFuture;
    private final MonitorService monitorService;

    public JsrvMonitor(MonitorService monitorService, MonitorDataMap monitorDataMap) {
        this.collect(monitorDataMap);
        this.monitorService = monitorService;
        this.sendFuture = this.scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    JsrvMonitor.this.send();
                }
                catch (Throwable var2) {
                    LogUtil.error("Unexpected error occur at send statistic, cause: " + var2.getMessage(), var2);
                }
            }
        }, 60000L, 60000L, TimeUnit.MILLISECONDS);
    }

    public void send() {
        LogUtil.debug("Send statistics to monitor ");
        for (Map.Entry entry : this.statisticsMap.entrySet()) {
            long[] current;
            AtomicReference reference = (AtomicReference)entry.getValue();
            long[] numbers = (long[])reference.get();
            long success = numbers[0];
            long failure = numbers[1];
            long elapsed = numbers[2];
            long maxElapsed = numbers[3];
            long concurrent = numbers[4];
            long maxConcurrent = numbers[5];
            if (success == 0L && failure == 0L) continue;
            MonitorDataMap monitorDataMap = new MonitorDataMap();
            monitorDataMap.put("path", (String)entry.getKey());
            monitorDataMap.put("success", String.valueOf(success));
            monitorDataMap.put("failure", String.valueOf(failure));
            monitorDataMap.put("elapsed", String.valueOf(elapsed / (success + failure)));
            monitorDataMap.put("maxElapsed", String.valueOf(maxElapsed));
            monitorDataMap.put("concurrent", String.valueOf(concurrent / (success + failure)));
            monitorDataMap.put("maxConcurrent", String.valueOf(maxConcurrent));
            monitorDataMap.setReceiveTime(DateUtil.getCurTimes());
            this.monitorService.collect(monitorDataMap);
            LogUtil.info("send: " + JSON.toJSONString((Object)monitorDataMap));
            long[] update = new long[6];
            do {
                if ((current = (long[])reference.get()) == null) {
                    update[0] = 0L;
                    update[1] = 0L;
                    update[2] = 0L;
                    update[3] = 0L;
                    update[4] = 0L;
                    update[5] = 0L;
                    continue;
                }
                update[0] = current[0] - success;
                update[1] = current[1] - failure;
                update[2] = current[2] - elapsed;
                update[3] = 0L;
                update[4] = 0L;
                update[5] = 0L;
            } while (!reference.compareAndSet(current, update));
        }
    }

    @Override
    public void collect(MonitorDataMap monitorDataMap) {
        long[] current;
        String path = monitorDataMap.getPath();
        long success = monitorDataMap.getParameter("success", 0);
        long failure = monitorDataMap.getParameter("failure", 0);
        long elapsed = monitorDataMap.getParameter("elapsed", 0);
        int concurrent = monitorDataMap.getParameter("concurrent", 0);
        AtomicReference reference = (AtomicReference)this.statisticsMap.get(path);
        if (reference == null) {
            this.statisticsMap.putIfAbsent(path, new AtomicReference());
            reference = (AtomicReference)this.statisticsMap.get(path);
        }
        long[] update = new long[6];
        do {
            if ((current = (long[])reference.get()) == null) {
                update[0] = success;
                update[1] = failure;
                update[2] = elapsed;
                update[3] = elapsed;
                update[4] = concurrent;
                update[5] = concurrent;
                continue;
            }
            update[0] = current[0] + success;
            update[1] = current[1] + failure;
            update[2] = current[2] + elapsed;
            update[3] = current[3] > elapsed ? current[3] : elapsed;
            update[4] = current[4] + (long)concurrent;
            long l = update[5] = current[5] > (long)concurrent ? current[5] : (long)concurrent;
        } while (!reference.compareAndSet(current, update));
    }

    public void destroy() {
        try {
            this.sendFuture.cancel(true);
        }
        catch (Throwable var2) {
            LogUtil.error("Unexpected error occur at cancel sender timer, cause: " + var2.getMessage(), var2);
        }
    }
}

