/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.render;

import com.ydn.jsrv.core.JSrv;
import com.ydn.jsrv.exception.RenderException;
import com.ydn.jsrv.render.Render;
import com.ydn.jsrv.tool.template.Engine;
import com.ydn.jsrv.tool.template.io.ByteWriter;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;

public class TemplateRender
extends Render {
    protected String view;
    protected static Engine engine;
    private static final String contentType;

    public TemplateRender(String view) {
        this.view = view;
    }

    static void init(Engine engine) {
        if (engine == null) {
            throw new IllegalArgumentException("engine can not be null");
        }
        TemplateRender.engine = engine;
    }

    public String getContentType() {
        return contentType;
    }

    String getContxtPath() {
        String cp = JSrv.me().getContextPath();
        return "".equals(cp) || "/".equals(cp) ? null : cp;
    }

    @Override
    public void render() {
        this.response.setContentType(this.getContentType());
        ByteWriter byteWriter = null;
        HashMap<String, Object> data = new HashMap<String, Object>();
        Enumeration attrs = this.request.getAttributeNames();
        while (attrs.hasMoreElements()) {
            String attrName = (String)attrs.nextElement();
            data.put(attrName, this.request.getAttribute(attrName));
        }
        try {
            engine.getTemplate(this.view).render(data, (OutputStream)this.response.getOutputStream());
        }
        catch (Exception e) {
            throw new RenderException(e);
        }
        finally {
            if (byteWriter != null) {
                byteWriter.close();
            }
        }
    }

    public String toString() {
        return this.view;
    }

    static {
        contentType = "text/html; charset=" + encoding;
    }
}

