/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.tool.template.ext.directive;

import com.ydn.jsrv.tool.template.Directive;
import com.ydn.jsrv.tool.template.Env;
import com.ydn.jsrv.tool.template.TemplateException;
import com.ydn.jsrv.tool.template.io.Writer;
import com.ydn.jsrv.tool.template.stat.ParseException;
import com.ydn.jsrv.tool.template.stat.Scope;
import java.io.IOException;

public class EscapeDirective
extends Directive {
    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        try {
            Object value = this.exprList.eval(scope);
            if (value instanceof String) {
                this.escape((String)value, writer);
            } else if (value instanceof Number) {
                Class<?> c = value.getClass();
                if (c == Integer.class) {
                    writer.write((Integer)value);
                } else if (c == Long.class) {
                    writer.write((Long)value);
                } else if (c == Double.class) {
                    writer.write((Double)value);
                } else if (c == Float.class) {
                    writer.write(((Float)value).floatValue());
                } else if (c == Short.class) {
                    writer.write((Short)value);
                } else {
                    writer.write(value.toString());
                }
            } else if (value != null) {
                this.escape(value.toString(), writer);
            }
        }
        catch (TemplateException | ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TemplateException(e.getMessage(), this.location, e);
        }
    }

    private void escape(String str, Writer w) throws IOException {
        int len = str.length();
        block7: for (int i = 0; i < len; ++i) {
            char cur = str.charAt(i);
            switch (cur) {
                case '<': {
                    w.write("&lt;");
                    continue block7;
                }
                case '>': {
                    w.write("&gt;");
                    continue block7;
                }
                case '\"': {
                    w.write("&quot;");
                    continue block7;
                }
                case '\'': {
                    w.write("&#39;");
                    continue block7;
                }
                case '&': {
                    w.write("&amp;");
                    continue block7;
                }
                default: {
                    w.write(str, i, 1);
                }
            }
        }
    }
}

