/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.tool.template.ext.directive;

import com.ydn.jsrv.tool.template.Directive;
import com.ydn.jsrv.tool.template.Env;
import com.ydn.jsrv.tool.template.TemplateException;
import com.ydn.jsrv.tool.template.expr.ast.ExprList;
import com.ydn.jsrv.tool.template.io.Writer;
import com.ydn.jsrv.tool.template.stat.ParseException;
import com.ydn.jsrv.tool.template.stat.Scope;
import java.io.IOException;
import java.util.Date;

public class NowDirective
extends Directive {
    @Override
    public void setExprList(ExprList exprList) {
        if (exprList.length() > 1) {
            throw new ParseException("#now directive support one parameter only", this.location);
        }
        super.setExprList(exprList);
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        String datePattern;
        if (this.exprList.length() == 0) {
            datePattern = env.getEngineConfig().getDatePattern();
        } else {
            Object dp = this.exprList.eval(scope);
            if (dp instanceof String) {
                datePattern = (String)dp;
            } else {
                throw new TemplateException("The parameter of #now directive must be String", this.location);
            }
        }
        try {
            writer.write(new Date(), datePattern);
        }
        catch (IOException e) {
            throw new TemplateException(e.getMessage(), this.location, e);
        }
    }
}

