/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.tool.template.io;

import com.ydn.jsrv.tool.template.io.ByteWriter;
import com.ydn.jsrv.tool.template.io.CharWriter;
import com.ydn.jsrv.tool.template.io.EncoderFactory;
import com.ydn.jsrv.tool.template.io.FastStringWriter;
import java.io.OutputStream;
import java.io.Writer;

public class WriterBuffer {
    private static final int MIN_BUFFER_SIZE = 64;
    private static final int MAX_BUFFER_SIZE = 0xA00000;
    private int bufferSize = 2048;
    private EncoderFactory encoderFactory = new EncoderFactory();
    private final ThreadLocal<ByteWriter> byteWriters = new ThreadLocal<ByteWriter>(){

        @Override
        protected ByteWriter initialValue() {
            return new ByteWriter(WriterBuffer.this.encoderFactory.getEncoder(), WriterBuffer.this.bufferSize);
        }
    };
    private final ThreadLocal<CharWriter> charWriters = new ThreadLocal<CharWriter>(){

        @Override
        protected CharWriter initialValue() {
            return new CharWriter(WriterBuffer.this.bufferSize);
        }
    };
    private final ThreadLocal<FastStringWriter> fastStringWriters = new ThreadLocal<FastStringWriter>(){

        @Override
        protected FastStringWriter initialValue() {
            return new FastStringWriter();
        }
    };

    public ByteWriter getByteWriter(OutputStream outputStream) {
        return this.byteWriters.get().init(outputStream);
    }

    public CharWriter getCharWriter(Writer writer) {
        return this.charWriters.get().init(writer);
    }

    public FastStringWriter getFastStringWriter() {
        return this.fastStringWriters.get();
    }

    public void setBufferSize(int bufferSize) {
        if (bufferSize < 64 || bufferSize > 0xA00000) {
            throw new IllegalArgumentException("bufferSize must between 63 and 10485761");
        }
        this.bufferSize = bufferSize;
    }

    public void setEncoderFactory(EncoderFactory encoderFactory) {
        if (encoderFactory == null) {
            throw new IllegalArgumentException("encoderFactory can not be null");
        }
        this.encoderFactory = encoderFactory;
    }

    public void setEncoding(String encoding) {
        this.encoderFactory.setEncoding(encoding);
    }
}

