/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.tool.template.stat;

import java.util.HashMap;
import java.util.Map;

enum Symbol {
    TEXT("text", false),
    OUTPUT("output", true),
    DEFINE("define", true),
    CALL("call", true),
    CALL_IF_DEFINED("callIfDefined", true),
    SET("set", true),
    SET_LOCAL("setLocal", true),
    SET_GLOBAL("setGlobal", true),
    INCLUDE("include", true),
    FOR("for", true),
    IF("if", true),
    ELSEIF("elseif", true),
    ELSE("else", false),
    END("end", false),
    CONTINUE("continue", false),
    BREAK("break", false),
    RETURN("return", false),
    SWITCH("switch", true),
    CASE("case", true),
    DEFAULT("default", false),
    ID("ID", false),
    PARA("PARA", false),
    EOF("EOF", false);

    private final String name;
    private final boolean hasPara;
    private static final Map<String, Symbol> keywords;

    private Symbol(String name, boolean hasPara) {
        this.name = name;
        this.hasPara = hasPara;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    boolean hasPara() {
        return this.hasPara;
    }

    boolean noPara() {
        return !this.hasPara;
    }

    public static Symbol getKeywordSym(String name) {
        return keywords.get(name);
    }

    static {
        keywords = new HashMap<String, Symbol>(64){
            {
                this.put(IF.getName(), IF);
                this.put(ELSEIF.getName(), ELSEIF);
                this.put(ELSE.getName(), ELSE);
                this.put(END.getName(), END);
                this.put(FOR.getName(), FOR);
                this.put(BREAK.getName(), BREAK);
                this.put(CONTINUE.getName(), CONTINUE);
                this.put(RETURN.getName(), RETURN);
                this.put(SWITCH.getName(), SWITCH);
                this.put(CASE.getName(), CASE);
                this.put(DEFAULT.getName(), DEFAULT);
                this.put(DEFINE.getName(), DEFINE);
                this.put(SET.getName(), SET);
                this.put(SET_LOCAL.getName(), SET_LOCAL);
                this.put(SET_GLOBAL.getName(), SET_GLOBAL);
                this.put(INCLUDE.getName(), INCLUDE);
            }
        };
    }
}

