/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.tool.template.stat.ast;

import com.ydn.jsrv.tool.template.Env;
import com.ydn.jsrv.tool.template.expr.ast.Expr;
import com.ydn.jsrv.tool.template.expr.ast.ExprList;
import com.ydn.jsrv.tool.template.expr.ast.Logic;
import com.ydn.jsrv.tool.template.io.Writer;
import com.ydn.jsrv.tool.template.stat.Location;
import com.ydn.jsrv.tool.template.stat.ParseException;
import com.ydn.jsrv.tool.template.stat.Scope;
import com.ydn.jsrv.tool.template.stat.ast.Stat;
import com.ydn.jsrv.tool.template.stat.ast.StatList;

public class ElseIf
extends Stat {
    private Expr cond;
    private Stat stat;
    private Stat elseIfOrElse;

    public ElseIf(ExprList cond, StatList statList, Location location) {
        if (cond.length() == 0) {
            throw new ParseException("The condition expression of #else if statement can not be blank", location);
        }
        this.cond = cond.getActualExpr();
        this.stat = statList.getActualStat();
    }

    @Override
    public void setStat(Stat elseIfOrElse) {
        this.elseIfOrElse = elseIfOrElse;
    }

    @Override
    public void exec(Env env, Scope scope, Writer writer) {
        if (Logic.isTrue(this.cond.eval(scope))) {
            this.stat.exec(env, scope, writer);
        } else if (this.elseIfOrElse != null) {
            this.elseIfOrElse.exec(env, scope, writer);
        }
    }
}

