/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.tool.upload;

import com.ydn.jsrv.config.yaml.GlobalYamlConfiguration;
import com.ydn.jsrv.tool.upload.MultiRequest;
import com.ydn.jsrv.util.PathUtil;
import com.ydn.jsrv.util.StrUtil;
import java.io.File;

public class MultiUploadConfig {
    private static final String UPLOAD_PATH = "jsrv.upload.uploadPath";
    private static final String MAX_POST_SIZE = "jsrv.upload.maxPostSize";
    private static final String ENCODEING = "jsrv.upload.encode";

    public static void init() {
        String uploadPath = GlobalYamlConfiguration.getString(UPLOAD_PATH);
        int maxPostSize = GlobalYamlConfiguration.getInt(MAX_POST_SIZE, 0xA00000);
        String encoding = GlobalYamlConfiguration.getString(ENCODEING, "UTF-8");
        if (StrUtil.isBlank(uploadPath)) {
            throw new IllegalArgumentException("uploadPath can not be null.");
        }
        MultiUploadConfig.doInit(uploadPath, maxPostSize, encoding);
    }

    public static boolean openUpload() {
        return StrUtil.isNotBlank(GlobalYamlConfiguration.getString(UPLOAD_PATH));
    }

    private static void doInit(String uploadPath, int maxPostSize, String encoding) {
        uploadPath = uploadPath.trim();
        String baseUploadPath = PathUtil.isAbsolutePath(uploadPath = uploadPath.replaceAll("\\\\", "/")) ? uploadPath : PathUtil.getWebRootPath() + File.separator + uploadPath;
        if (!baseUploadPath.equals("/") && baseUploadPath.endsWith("/")) {
            baseUploadPath = baseUploadPath.substring(0, baseUploadPath.length() - 1);
        }
        MultiRequest.init(baseUploadPath, maxPostSize, encoding);
    }
}

