/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.undertow;

import com.ydn.jsrv.config.yaml.GlobalYamlConfiguration;
import com.ydn.jsrv.undertow.ResourceManagerBuilder;
import com.ydn.jsrv.undertow.UndertowKit;
import com.ydn.jsrv.undertow.hotswap.ClassLoaderKit;
import com.ydn.jsrv.undertow.hotswap.HotSwapResolver;
import com.ydn.jsrv.undertow.ssl.SslConfig;
import io.undertow.Undertow;
import io.undertow.server.handlers.resource.ResourceManager;

public class UndertowConfig {
    static final String DEV_MODE = "undertow.devMode";
    public static final String PORT = "undertow.port";
    public static final String HOST = "undertow.host";
    static final String CONTEXT_PATH = "undertow.contextPath";
    static final String RESOURCE_PATH = "undertow.resourcePath";
    static final String IO_THREADS = "undertow.ioThreads";
    static final String WORKER_THREADS = "undertow.workerThreads";
    static final String GZIP_ENABLE = "undertow.gzip.enable";
    static final String GZIP_LEVEL = "undertow.gzip.level";
    static final String GZIP_MIN_LENGTH = "undertow.gzip.minLength";
    static final String HTTP2_ENABLE = "undertow.http2.enable";
    static final String SESSION_TIMEOUT = "undertow.session.timeout";
    static final String SESSION_HOT_SWAP = "undertow.session.hotSwap";
    static final String HOT_SWAP_CLASS_PREFIX = "undertow.hotSwapClassPrefix";
    static final String HTTP_TO_HTTPS = "undertow.http.toHttps";
    static final String HTTP_TO_HTTPS_STATUS_CODE = "undertow.http.toHttpsStatusCode";
    static final String HTTP_DISABLE = "undertow.http.disable";
    protected String JSrvBooterClass;
    protected static volatile boolean devMode = false;
    protected int port = 80;
    protected String host = "localhost";
    protected String contextPath = "/";
    protected String resourcePath = "src/main/webapp, WebRoot, WebContent";
    protected Integer ioThreads = null;
    protected Integer workerThreads = null;
    protected boolean gzipEnable = false;
    protected int gzipLevel = -1;
    protected int gzipMinLength = 1024;
    protected Boolean http2Enable = null;
    protected Integer sessionTimeout = null;
    protected boolean sessionHotSwap = true;
    protected String hotSwapClassPrefix = null;
    protected SslConfig sslConfig = null;
    protected boolean httpToHttps = false;
    protected int httpToHttpsStatusCode = 302;
    protected boolean httpDisable = false;
    protected String[] classPathDirs;
    protected HotSwapResolver hotSwapResolver;
    protected ClassLoaderKit classLoaderKit;

    public UndertowConfig(Class<?> JSrvBooterClass) {
        this.JSrvBooterClass = JSrvBooterClass.getName();
        this.init();
    }

    protected void init() {
        if (!GlobalYamlConfiguration.me().isBuilded()) {
            GlobalYamlConfiguration.me().buildPropFile();
        }
        devMode = GlobalYamlConfiguration.getBoolean(DEV_MODE, devMode);
        this.port = GlobalYamlConfiguration.getInt(PORT, this.port);
        this.host = GlobalYamlConfiguration.getString(HOST, this.host).trim();
        this.contextPath = GlobalYamlConfiguration.getString(CONTEXT_PATH, this.contextPath).trim();
        this.resourcePath = GlobalYamlConfiguration.getString(RESOURCE_PATH, this.resourcePath).trim();
        this.ioThreads = this.buildIoThreads();
        this.workerThreads = GlobalYamlConfiguration.getInt(WORKER_THREADS, this.workerThreads);
        this.gzipEnable = GlobalYamlConfiguration.getBoolean(GZIP_ENABLE, this.gzipEnable);
        this.gzipLevel = this.checkGzipLevel(GlobalYamlConfiguration.getInt(GZIP_LEVEL, this.gzipLevel));
        this.gzipMinLength = GlobalYamlConfiguration.getInt(GZIP_MIN_LENGTH, this.gzipMinLength);
        this.http2Enable = GlobalYamlConfiguration.getBoolean(HTTP2_ENABLE, this.http2Enable);
        this.sessionTimeout = GlobalYamlConfiguration.getInt(SESSION_TIMEOUT, this.sessionTimeout);
        this.sessionHotSwap = GlobalYamlConfiguration.getBoolean(SESSION_HOT_SWAP, this.sessionHotSwap);
        this.hotSwapClassPrefix = GlobalYamlConfiguration.getString(HOT_SWAP_CLASS_PREFIX, this.hotSwapClassPrefix);
        this.sslConfig = new SslConfig();
        this.httpToHttps = GlobalYamlConfiguration.getBoolean(HTTP_TO_HTTPS, this.httpToHttps);
        this.httpToHttpsStatusCode = GlobalYamlConfiguration.getInt(HTTP_TO_HTTPS_STATUS_CODE, this.httpToHttpsStatusCode);
        this.httpDisable = GlobalYamlConfiguration.getBoolean(HTTP_DISABLE, this.httpDisable);
    }

    protected Integer buildIoThreads() {
        Integer valueFromConfig = GlobalYamlConfiguration.getInt(IO_THREADS);
        if (valueFromConfig != null) {
            return valueFromConfig;
        }
        int cpuNum = Runtime.getRuntime().availableProcessors();
        if (UndertowConfig.isDevMode() && UndertowKit.notDeployMode()) {
            return Math.min(4, cpuNum);
        }
        return cpuNum * 2;
    }

    protected int checkGzipLevel(int gzipLevel) {
        if (gzipLevel != -1 && (gzipLevel < 1 || gzipLevel > 9)) {
            throw new IllegalArgumentException("undertow.gzip.level \u4e0d\u80fd\u914d\u7f6e\u4e3a " + gzipLevel + ", \u53ef\u914d\u7f6e\u7684\u503c\u4e3a: -1, 1, 2, 3, 4, 5, 6, 7, 8, 9");
        }
        return gzipLevel;
    }

    public static boolean isBlank(String str) {
        return str == null || "".equals(str.trim());
    }

    public static boolean notBlank(String str) {
        return !UndertowConfig.isBlank(str);
    }

    public String getJSrvBooterClass() {
        return this.JSrvBooterClass;
    }

    public ResourceManager getResourceManager() {
        return new ResourceManagerBuilder().build(this.resourcePath, this.getClassLoader());
    }

    protected ClassLoaderKit getClassLoaderKit() {
        if (this.classLoaderKit == null) {
            this.classLoaderKit = new ClassLoaderKit(Undertow.class.getClassLoader(), this.getHotSwapResolver());
        }
        return this.classLoaderKit;
    }

    public ClassLoader getClassLoader() {
        return this.getClassLoaderKit().getClassLoader();
    }

    public void replaceClassLoader() {
        if (UndertowConfig.isDevMode()) {
            this.getClassLoaderKit().replaceClassLoader();
        }
    }

    public HotSwapResolver getHotSwapResolver() {
        if (this.hotSwapResolver == null) {
            this.hotSwapResolver = new HotSwapResolver(this.getClassPathDirs());
            if (this.hotSwapClassPrefix != null) {
                for (String prefix : this.hotSwapClassPrefix.split(",")) {
                    if (!UndertowConfig.notBlank(prefix)) continue;
                    this.hotSwapResolver.addHotSwapClassPrefix(prefix);
                }
            }
        }
        return this.hotSwapResolver;
    }

    public void setHotSwapResolver(HotSwapResolver hotSwapResolver) {
        this.hotSwapResolver = hotSwapResolver;
    }

    public void addSystemClassPrefix(String prefix) {
        this.getHotSwapResolver().addSystemClassPrefix(prefix);
    }

    public void addHotSwapClassPrefix(String prefix) {
        this.getHotSwapResolver().addHotSwapClassPrefix(prefix);
    }

    public String[] getClassPathDirs() {
        if (this.classPathDirs == null) {
            this.classPathDirs = UndertowKit.getClassPathDirs();
        }
        return this.classPathDirs;
    }

    public static boolean isDevMode() {
        return GlobalYamlConfiguration.getBoolean(DEV_MODE, devMode);
    }

    public int getPort() {
        return this.port;
    }

    public String getContextPath() {
        if ("/".equals(this.contextPath)) {
            return this.contextPath;
        }
        if (UndertowConfig.isBlank(this.contextPath)) {
            this.contextPath = "/";
            return this.contextPath;
        }
        if (!this.contextPath.startsWith("/")) {
            this.contextPath = "/" + this.contextPath;
        }
        if (this.contextPath.endsWith("/")) {
            this.contextPath = this.contextPath.substring(0, this.contextPath.length() - 1);
        }
        return this.contextPath;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getIoThreads() {
        return this.ioThreads;
    }

    public Integer getWorkerThreads() {
        return this.workerThreads;
    }

    public boolean isGzipEnable() {
        return this.gzipEnable;
    }

    public int getGzipLevel() {
        return this.gzipLevel;
    }

    public int getGzipMinLength() {
        return this.gzipMinLength;
    }

    public Boolean getHttp2Enable() {
        return this.http2Enable;
    }

    public Integer getSessionTimeout() {
        return this.sessionTimeout;
    }

    public boolean getSessionHotSwap() {
        return this.sessionHotSwap;
    }

    public boolean isSslEnable() {
        return this.sslConfig != null && this.sslConfig.isEnable();
    }

    public SslConfig getSslConfig() {
        return this.sslConfig;
    }

    public boolean isHttpToHttps() {
        return this.httpToHttps;
    }

    public int getHttpToHttpsStatusCode() {
        return this.httpToHttpsStatusCode;
    }

    public boolean isHttpDisable() {
        return this.httpDisable;
    }
}

