/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.util;

import com.ydn.jsrv.util.StrUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class PathUtil {
    private static String webRootPath;
    private static String rootClassPath;
    private static final String jsrvHome = "JSRV_HOME";

    public static String getPath(Class clazz) {
        String path = clazz.getResource("").getPath();
        return new File(path).getAbsolutePath();
    }

    public static String getPath(Object object) {
        String path = object.getClass().getResource("").getPath();
        return new File(path).getAbsolutePath();
    }

    public static String getRootClassPath() {
        if (rootClassPath == null) {
            try {
                String path = PathUtil.getClassLoader().getResource("").toURI().getPath();
                rootClassPath = new File(path).getAbsolutePath();
            }
            catch (Exception e) {
                try {
                    String path = PathUtil.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                    path = URLDecoder.decode(path, "UTF-8");
                    if (path.endsWith(File.separator)) {
                        path = path.substring(0, path.length() - 1);
                    }
                    rootClassPath = path;
                }
                catch (UnsupportedEncodingException e1) {
                    throw new RuntimeException(e1);
                }
            }
        }
        return rootClassPath;
    }

    private static ClassLoader getClassLoader() {
        ClassLoader ret = Thread.currentThread().getContextClassLoader();
        return ret != null ? ret : PathUtil.class.getClassLoader();
    }

    public static void setRootClassPath(String rootClassPath) {
        PathUtil.rootClassPath = rootClassPath;
    }

    public static String getPackagePath(Object object) {
        Package p = object.getClass().getPackage();
        return p != null ? p.getName().replaceAll("\\.", "/") : "";
    }

    public static File getFileFromJar(String file) {
        throw new RuntimeException("Not finish. Do not use this method.");
    }

    public static String getWebRootPath() {
        if (webRootPath == null) {
            webRootPath = PathUtil.detectWebRootPath();
        }
        return webRootPath;
    }

    public static void setWebRootPath(String webRootPath) {
        if (webRootPath == null) {
            return;
        }
        if (webRootPath.endsWith(File.separator)) {
            webRootPath = webRootPath.substring(0, webRootPath.length() - 1);
        }
        PathUtil.webRootPath = webRootPath;
    }

    private static String detectWebRootPath() {
        try {
            String path = PathUtil.getClassRootPath();
            return new File(path).getParentFile().getParentFile().getCanonicalPath();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getClassRootPath() {
        try {
            return PathUtil.class.getResource("/").toURI().getPath();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getConfigPath() {
        String home = System.getProperty(jsrvHome);
        if (StrUtil.isBlank(home)) {
            home = PathUtil.getClassRootPath();
        }
        return home;
    }

    public static boolean isAbsolutePath(String path) {
        return path.startsWith("/") || path.indexOf(58) == 1;
    }

    public static void main(String[] args) {
        String home = PathUtil.getClassRootPath();
        String[] list = new File(home).list();
        System.out.println(list.length);
        System.out.println(home);
    }
}

