/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.util;

import com.ydn.jsrv.util.StrUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValidateUtil {
    private static final String emailAddressPattern = "\\b(^['_A-Za-z0-9-]+(\\.['_A-Za-z0-9-]+)*@([A-Za-z0-9-])+(\\.[A-Za-z0-9-]+)*((\\.[A-Za-z0-9]{2,})|(\\.[A-Za-z0-9]{2,}\\.[A-Za-z0-9]{2,}))$)\\b";
    protected static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd";
    private static final String phonePattern = "^1[3456789]\\d{9}$";

    protected static boolean validateUrl(String url) {
        if (StrUtil.isBlank(url)) {
            return false;
        }
        try {
            url = url.trim();
            if (url.startsWith("https://")) {
                url = "http://" + url.substring(8);
            }
            new URL(url);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static boolean validateDate(String str, String format) {
        if (StrUtil.isBlank(str)) {
            return false;
        }
        try {
            new SimpleDateFormat(DEFAULT_DATE_PATTERN).parse(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean validateDate(String str) {
        return ValidateUtil.validateDate(str, DEFAULT_DATE_PATTERN);
    }

    public static boolean validateEmail(String str) {
        return ValidateUtil.validateRegex(str, emailAddressPattern, false);
    }

    public static boolean validatePhone(String str) {
        return ValidateUtil.validateRegex(str, phonePattern, false);
    }

    public static boolean validateRegex(String str, String regExpression, boolean isCaseSensitive) {
        if (StrUtil.isBlank(str)) {
            return false;
        }
        Pattern pattern = isCaseSensitive ? Pattern.compile(regExpression) : Pattern.compile(regExpression, 2);
        Matcher matcher = pattern.matcher(str);
        return matcher.matches();
    }
}

