/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.interceptor;

import com.ydn.jsrv.annotation.ParamType;
import com.ydn.jsrv.annotation.RequestMethod;
import com.ydn.jsrv.annotation.RequestParam;
import com.ydn.jsrv.core.Controller;
import com.ydn.jsrv.interceptor.Interceptor;
import com.ydn.jsrv.interceptor.Invocation;
import com.ydn.jsrv.util.Ret;
import com.ydn.jsrv.util.StrUtil;
import com.ydn.jsrv.util.ValidateUtil;

public class RequestMappingInterceptor
implements Interceptor {
    @Override
    public void intercept(Invocation inv) {
        Controller controller = inv.getController();
        RequestMethod _requestMethod = controller.getAction().getMethonType();
        String requestMethon = controller.getRequest().getMethod();
        if (!_requestMethod.name().equals(requestMethon)) {
            controller.renderJson(Ret.error("\u8bf7\u4f7f\u7528" + _requestMethod.name() + "\u65b9\u5f0f"));
            return;
        }
        String errorInfo = this.validateRequestParam(controller);
        if (StrUtil.isBlank(errorInfo)) {
            inv.invoke();
        } else {
            controller.renderJson(Ret.error(errorInfo));
        }
    }

    protected String validateRequestParam(Controller controller) {
        RequestParam[] params = controller.getAction().getRequestParam();
        if (params == null) {
            return null;
        }
        for (RequestParam param : params) {
            if (param.required() && !this.validateRequired(controller, param.value())) {
                return param.name() + " " + param.tips();
            }
            if (ParamType.STRING.name().equals(param.type().name()) || this.validateType(controller, param.type().name(), param.value())) continue;
            return param.name() + " \u7c7b\u578b\u9519\u8bef";
        }
        return null;
    }

    protected boolean validateType(Controller controller, String type, String field) {
        String value = controller.getPara(field);
        if (StrUtil.isBlank(value)) {
            return true;
        }
        if (ParamType.CAPTCHA.name().equals(type)) {
            return controller.validateCaptcha(field);
        }
        if (ParamType.EMAIl.name().equals(type)) {
            return ValidateUtil.validateEmail(value);
        }
        if (ParamType.PHONE.name().equals(type)) {
            return ValidateUtil.validatePhone(value);
        }
        return true;
    }

    protected boolean validateRequired(Controller controller, String field) {
        String value = controller.getPara(field);
        return value != null && !"".equals(value);
    }
}

