/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.log;

import com.ydn.jsrv.log.Log;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JdkLog
extends Log {
    private Logger log;
    private String clazzName;

    JdkLog(Class<?> clazz) {
        this.log = Logger.getLogger(clazz.getName());
        this.clazzName = clazz.getName();
    }

    JdkLog(String name) {
        this.log = Logger.getLogger(name);
        this.clazzName = name;
    }

    public static JdkLog getLog(Class<?> clazz) {
        return new JdkLog(clazz);
    }

    public static JdkLog getLog(String name) {
        return new JdkLog(name);
    }

    @Override
    public void debug(String message) {
        this.log.logp(Level.FINE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message);
    }

    @Override
    public void debug(String message, Throwable t) {
        this.log.logp(Level.FINE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message, t);
    }

    @Override
    public void info(String message) {
        this.log.logp(Level.INFO, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message);
    }

    @Override
    public void info(String message, Throwable t) {
        this.log.logp(Level.INFO, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message, t);
    }

    @Override
    public void warn(String message) {
        this.log.logp(Level.WARNING, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message);
    }

    @Override
    public void warn(String message, Throwable t) {
        this.log.logp(Level.WARNING, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message, t);
    }

    @Override
    public void error(String message) {
        this.log.logp(Level.SEVERE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message);
    }

    @Override
    public void error(String message, Throwable t) {
        this.log.logp(Level.SEVERE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message, t);
    }

    @Override
    public void fatal(String message) {
        this.log.logp(Level.SEVERE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message);
    }

    @Override
    public void fatal(String message, Throwable t) {
        this.log.logp(Level.SEVERE, this.clazzName, Thread.currentThread().getStackTrace()[1].getMethodName(), message, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isLoggable(Level.FINE);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log.isLoggable(Level.INFO);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.log.isLoggable(Level.WARNING);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.log.isLoggable(Level.SEVERE);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.log.isLoggable(Level.SEVERE);
    }
}

