/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.plugin.activerecord;

import com.ydn.jsrv.plugin.IPlugin;
import com.ydn.jsrv.plugin.activerecord.Config;
import com.ydn.jsrv.plugin.activerecord.DbKit;
import com.ydn.jsrv.plugin.activerecord.IContainerFactory;
import com.ydn.jsrv.plugin.activerecord.IDataSourceProvider;
import com.ydn.jsrv.plugin.activerecord.IDbProFactory;
import com.ydn.jsrv.plugin.activerecord.Model;
import com.ydn.jsrv.plugin.activerecord.NullDataSource;
import com.ydn.jsrv.plugin.activerecord.Table;
import com.ydn.jsrv.plugin.activerecord.TableBuilder;
import com.ydn.jsrv.plugin.activerecord.dialect.Dialect;
import com.ydn.jsrv.plugin.activerecord.dialect.MysqlDialect;
import com.ydn.jsrv.util.StrUtil;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;

public class ActiveRecordPlugin
implements IPlugin {
    protected IDataSourceProvider dataSourceProvider = null;
    protected Boolean devMode = null;
    protected Config config = null;
    protected volatile boolean isStarted = false;
    protected List<Table> tableList = new ArrayList<Table>();

    public ActiveRecordPlugin(String configName, DataSource dataSource, int transactionLevel) {
        if (StrUtil.isBlank(configName)) {
            throw new IllegalArgumentException("configName can not be blank");
        }
        if (dataSource == null) {
            throw new IllegalArgumentException("dataSource can not be null");
        }
        this.config = new Config(configName, dataSource, transactionLevel);
    }

    public ActiveRecordPlugin(DataSource dataSource) {
        this("main", dataSource);
    }

    public ActiveRecordPlugin(String configName, DataSource dataSource) {
        this(configName, dataSource, 4);
    }

    public ActiveRecordPlugin(DataSource dataSource, int transactionLevel) {
        this("main", dataSource, transactionLevel);
    }

    public ActiveRecordPlugin(String configName, IDataSourceProvider dataSourceProvider, int transactionLevel) {
        if (StrUtil.isBlank(configName)) {
            throw new IllegalArgumentException("configName can not be blank");
        }
        if (dataSourceProvider == null) {
            throw new IllegalArgumentException("dataSourceProvider can not be null");
        }
        this.dataSourceProvider = dataSourceProvider;
        this.config = new Config(configName, null, transactionLevel);
    }

    public ActiveRecordPlugin(IDataSourceProvider dataSourceProvider) {
        this("main", dataSourceProvider);
    }

    public ActiveRecordPlugin(String configName, IDataSourceProvider dataSourceProvider) {
        this(configName, dataSourceProvider, 4);
    }

    public ActiveRecordPlugin(IDataSourceProvider dataSourceProvider, int transactionLevel) {
        this("main", dataSourceProvider, transactionLevel);
    }

    public ActiveRecordPlugin(Config config) {
        if (config == null) {
            throw new IllegalArgumentException("Config can not be null");
        }
        this.config = config;
    }

    public ActiveRecordPlugin addMapping(String tableName, String primaryKey, Class<? extends Model<?>> modelClass) {
        this.tableList.add(new Table(tableName, primaryKey, modelClass));
        return this;
    }

    public ActiveRecordPlugin addMapping(String tableName, Class<? extends Model<?>> modelClass) {
        this.tableList.add(new Table(tableName, modelClass));
        return this;
    }

    public ActiveRecordPlugin setTransactionLevel(int transactionLevel) {
        this.config.setTransactionLevel(transactionLevel);
        return this;
    }

    public ActiveRecordPlugin setShowSql(boolean showSql) {
        this.config.showSql = showSql;
        return this;
    }

    public ActiveRecordPlugin setDialect(Dialect dialect) {
        if (dialect == null) {
            throw new IllegalArgumentException("dialect can not be null");
        }
        this.config.dialect = dialect;
        if (this.config.transactionLevel == 4 && dialect.isOracle()) {
            this.config.transactionLevel = 2;
        }
        return this;
    }

    public ActiveRecordPlugin setContainerFactory(IContainerFactory containerFactory) {
        if (containerFactory == null) {
            throw new IllegalArgumentException("containerFactory can not be null");
        }
        this.config.containerFactory = containerFactory;
        return this;
    }

    public ActiveRecordPlugin setDbProFactory(IDbProFactory dbProFactory) {
        if (dbProFactory == null) {
            throw new IllegalArgumentException("dbProFactory can not be null");
        }
        this.config.dbProFactory = dbProFactory;
        return this;
    }

    public void setPrimaryKey(String tableName, String primaryKey) {
        for (Table table : this.tableList) {
            if (!table.getName().equalsIgnoreCase(tableName.trim())) continue;
            table.setPrimaryKey(primaryKey);
        }
    }

    @Override
    public boolean start() {
        if (this.isStarted) {
            return true;
        }
        if (this.config.dataSource == null && this.dataSourceProvider != null) {
            this.config.dataSource = this.dataSourceProvider.getDataSource();
        }
        if (this.config.dataSource == null) {
            throw new RuntimeException("ActiveRecord start error: ActiveRecordPlugin need DataSource or DataSourceProvider");
        }
        new TableBuilder().build(this.tableList, this.config);
        DbKit.addConfig(this.config);
        this.isStarted = true;
        return true;
    }

    @Override
    public boolean stop() {
        DbKit.removeConfig(this.config.getName());
        this.isStarted = false;
        return true;
    }

    public static void useAsDataTransfer(Dialect dialect, IContainerFactory containerFactory) {
        if (dialect == null) {
            throw new IllegalArgumentException("dialect can not be null");
        }
        if (containerFactory == null) {
            throw new IllegalArgumentException("containerFactory can not be null");
        }
        ActiveRecordPlugin arp = new ActiveRecordPlugin(new NullDataSource());
        arp.setDialect(dialect);
        arp.setContainerFactory(containerFactory);
        arp.start();
        DbKit.brokenConfig = arp.config;
    }

    public static void useAsDataTransfer(IContainerFactory containerFactory) {
        ActiveRecordPlugin.useAsDataTransfer(new MysqlDialect(), containerFactory);
    }

    public static void useAsDataTransfer(Dialect dialect) {
        ActiveRecordPlugin.useAsDataTransfer(dialect, IContainerFactory.defaultContainerFactory);
    }

    public static void useAsDataTransfer() {
        ActiveRecordPlugin.useAsDataTransfer(new MysqlDialect(), IContainerFactory.defaultContainerFactory);
    }

    public Config getConfig() {
        return this.config;
    }
}

