/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.plugin.cron4j;

import com.ydn.jsrv.plugin.IPlugin;
import com.ydn.jsrv.plugin.cron4j.Cron4jConfig;
import com.ydn.jsrv.plugin.cron4j.ITask;
import com.ydn.jsrv.util.StrUtil;
import it.sauronsoftware.cron4j.ProcessTask;
import it.sauronsoftware.cron4j.Scheduler;
import it.sauronsoftware.cron4j.Task;
import java.util.ArrayList;
import java.util.List;

public class Cron4jPlugin
implements IPlugin {
    private List<TaskInfo> taskInfoList = new ArrayList<TaskInfo>();

    public List<TaskInfo> getTaskInfoList() {
        return this.taskInfoList;
    }

    public Cron4jPlugin(Cron4jConfig configProp) {
        try {
            this.addTask(configProp);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void addTask(Cron4jConfig config) throws Exception {
        String[] taskNameArray;
        String taskNames = config.getTaskNames();
        if (StrUtil.isBlank(taskNames)) {
            throw new IllegalArgumentException("The value of taskName: " + taskNames + " can not be blank.");
        }
        for (String taskName : taskNameArray = taskNames.trim().split(",")) {
            if (StrUtil.isBlank(taskName)) {
                throw new IllegalArgumentException("taskName can not be blank.");
            }
            taskName = taskName.trim();
            config.setTaskName(taskName);
            String taskCron = config.getCron();
            if (StrUtil.isBlank(taskCron)) {
                throw new IllegalArgumentException(taskName + ".cron not found.");
            }
            taskCron = taskCron.trim();
            String taskClass = config.getTaskClass();
            if (StrUtil.isBlank(taskClass)) {
                throw new IllegalArgumentException(taskName + ".class not found.");
            }
            Object taskObj = Class.forName(taskClass = taskClass.trim()).newInstance();
            if (!(taskObj instanceof Runnable) && !(taskObj instanceof Task)) {
                throw new IllegalArgumentException("Task \u5fc5\u987b\u662f Runnable\u3001ITask\u3001ProcessTask \u6216\u8005 Task \u7c7b\u578b");
            }
            boolean taskDaemon = config.isDaemon();
            boolean taskEnable = config.isEnable();
            this.taskInfoList.add(new TaskInfo(taskCron, taskObj, taskDaemon, taskEnable));
        }
    }

    public Cron4jPlugin addTask(String cron, Runnable task, boolean daemon, boolean enable) {
        this.taskInfoList.add(new TaskInfo(cron, task, daemon, enable));
        return this;
    }

    public Cron4jPlugin addTask(String cron, Runnable task, boolean daemon) {
        return this.addTask(cron, task, daemon, true);
    }

    public Cron4jPlugin addTask(String cron, Runnable task) {
        return this.addTask(cron, task, true, true);
    }

    public Cron4jPlugin addTask(String cron, ProcessTask processTask, boolean daemon, boolean enable) {
        this.taskInfoList.add(new TaskInfo(cron, processTask, daemon, enable));
        return this;
    }

    public Cron4jPlugin addTask(String cron, ProcessTask processTask, boolean daemon) {
        return this.addTask(cron, processTask, daemon, true);
    }

    public Cron4jPlugin addTask(String cron, ProcessTask processTask) {
        return this.addTask(cron, processTask, true, true);
    }

    public Cron4jPlugin addTask(String cron, Task task, boolean daemon, boolean enable) {
        this.taskInfoList.add(new TaskInfo(cron, task, daemon, enable));
        return this;
    }

    public Cron4jPlugin addTask(String cron, Task task, boolean daemon) {
        return this.addTask(cron, task, daemon, true);
    }

    public Cron4jPlugin addTask(String cron, Task task) {
        return this.addTask(cron, task, true, true);
    }

    @Override
    public boolean start() {
        for (TaskInfo taskInfo : this.taskInfoList) {
            taskInfo.schedule();
        }
        for (TaskInfo taskInfo : this.taskInfoList) {
            taskInfo.start();
        }
        return true;
    }

    @Override
    public boolean stop() {
        for (TaskInfo taskInfo : this.taskInfoList) {
            taskInfo.stop();
        }
        return true;
    }

    private static class TaskInfo {
        Scheduler scheduler;
        String cron;
        Object task;
        boolean daemon;
        boolean enable;

        TaskInfo(String cron, Object task, boolean daemon, boolean enable) {
            if (StrUtil.isBlank(cron)) {
                throw new IllegalArgumentException("cron \u4e0d\u80fd\u4e3a\u7a7a.");
            }
            if (task == null) {
                throw new IllegalArgumentException("task \u4e0d\u80fd\u4e3a null.");
            }
            this.cron = cron.trim();
            this.task = task;
            this.daemon = daemon;
            this.enable = enable;
        }

        void schedule() {
            if (this.enable) {
                this.scheduler = new Scheduler();
                if (this.task instanceof Runnable) {
                    this.scheduler.schedule(this.cron, (Runnable)this.task);
                } else if (this.task instanceof Task) {
                    this.scheduler.schedule(this.cron, (Task)this.task);
                } else {
                    this.scheduler = null;
                    throw new IllegalStateException("Task \u5fc5\u987b\u662f Runnable\u3001ITask\u3001ProcessTask \u6216\u8005 Task \u7c7b\u578b");
                }
                this.scheduler.setDaemon(this.daemon);
            }
        }

        void start() {
            if (this.enable) {
                this.scheduler.start();
            }
        }

        void stop() {
            if (this.enable) {
                if (this.task instanceof ITask) {
                    ((ITask)this.task).stop();
                }
                this.scheduler.stop();
            }
        }
    }
}

