/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.plugin.monitor.active;

import com.ydn.jsrv.plugin.monitor.active.ServerActive;
import com.ydn.jsrv.util.DateUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServerKit {
    private static final String START = "START";
    private static final String RUNNING = "RUNNING";
    private static final String INACTIVE = "INACTIVE";
    private static Map<String, ServerActive> serverActiveMap = new HashMap<String, ServerActive>();

    public static void start(String clientIp, String clientPort) {
        ServerActive clientInfo = ServerKit.getServerActive(clientIp, clientPort);
        clientInfo.setState(START);
        clientInfo.setStartTime(DateUtil.getCurTimes());
    }

    public static void serverIn(String clientIp, String clientPort) {
        ServerActive serverActive = ServerKit.getServerActive(clientIp, clientPort);
        if (START.equals(serverActive.getState())) {
            serverActive.setState(RUNNING);
            serverActive.setRunTime(DateUtil.getCurTimes());
        } else {
            serverActive.setLastHeartTime(DateUtil.getCurTimes());
        }
    }

    private static String getKey(String serverIp, String serverPort) {
        return serverIp + "_" + serverPort;
    }

    private static ServerActive getServerActive(String serverIp, String serverPort) {
        String appId = ServerKit.getKey(serverIp, serverPort);
        ServerActive serverActive = serverActiveMap.get(appId);
        if (serverActive == null) {
            serverActive = new ServerActive(appId);
            serverActiveMap.put(appId, serverActive);
        }
        return serverActive;
    }

    public static ServerActive get(String serverIp, String serverPort) {
        return serverActiveMap.get(ServerKit.getKey(serverIp, serverPort));
    }

    public static List<ServerActive> getAllServerActive() {
        ArrayList<ServerActive> list = new ArrayList<ServerActive>();
        serverActiveMap.forEach((key, value) -> list.add((ServerActive)value));
        return list;
    }
}

