/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.plugin.monitor.service;

import com.ydn.jsrv.plugin.monitor.MonitorDataMap;
import com.ydn.jsrv.plugin.monitor.service.MonitorService;
import com.ydn.jsrv.plugin.monitor.statistics.MonitorConsumeFactory;
import com.ydn.jsrv.util.LogUtil;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class ManagerMonitorService
implements MonitorService {
    private final BlockingQueue<MonitorDataMap> queue = new LinkedBlockingQueue<MonitorDataMap>(100000);
    private volatile boolean running = true;
    private final Thread consumeThread = new Thread(new Runnable(){

        @Override
        public void run() {
            while (ManagerMonitorService.this.running) {
                try {
                    ManagerMonitorService.this.consume();
                }
                catch (Throwable t) {
                    LogUtil.error("Unexpected error occur at write stat log, cause: " + t.getMessage(), t);
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
    });

    public ManagerMonitorService() {
        this.consumeThread.setDaemon(true);
        this.consumeThread.setName("JsrvMonitorAsyncConsumeLogThread");
        this.consumeThread.start();
    }

    private void consume() throws Exception {
        MonitorDataMap monitorDataMap = this.queue.take();
        MonitorConsumeFactory.me().getMonitorConsume().consume(monitorDataMap);
    }

    @Override
    public void collect(MonitorDataMap var1) {
        this.queue.offer(var1);
        if (LogUtil.isInfoEnabled()) {
            LogUtil.info("collect offer" + var1.toString());
        }
    }
}

