/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.plugin.monitor.statistics;

import com.ydn.jsrv.plugin.monitor.MonitorDataMap;
import com.ydn.jsrv.plugin.monitor.statistics.Element;
import com.ydn.jsrv.util.DateUtil;
import java.util.ArrayList;
import java.util.List;

public class HourElement {
    private long success = 0L;
    private long failure = 0L;
    private List<Element> elements;
    private String hour = DateUtil.getCurTimeFormat("yyyyMMddHH");
    private long maxElapsed = 0L;
    private int maxConcurrent = 0;

    protected HourElement() {
        this.elements = new ArrayList<Element>();
    }

    public String getHour() {
        return this.hour;
    }

    public void setHour(String hour) {
        this.hour = hour;
    }

    public long getSuccess() {
        return this.success;
    }

    public void setSuccess(long success) {
        this.success = success;
    }

    public long getFailure() {
        return this.failure;
    }

    public void setFailure(long failure) {
        this.failure = failure;
    }

    public List<Element> getElements() {
        return this.elements;
    }

    public void setElements(List<Element> elements) {
        this.elements = elements;
    }

    protected void addURL(MonitorDataMap monitorDataMap) {
        long success = monitorDataMap.getParameter("success", 0);
        long failure = monitorDataMap.getParameter("failure", 0);
        long elapsed = monitorDataMap.getParameter("elapsed", 0);
        long maxElapsed = monitorDataMap.getParameter("maxElapsed", 0);
        int maxConcurrent = monitorDataMap.getParameter("maxConcurrent", 0);
        int concurrent = monitorDataMap.getParameter("concurrent", 0);
        Element element = new Element(success, failure, concurrent, elapsed, maxElapsed, maxConcurrent);
        this.elements.add(element);
        this.success += success;
        this.failure += failure;
        this.maxElapsed = this.maxElapsed > maxElapsed ? this.maxElapsed : maxElapsed;
        this.maxConcurrent = this.maxConcurrent > maxConcurrent ? this.maxConcurrent : maxConcurrent;
    }

    protected void reset() {
        this.hour = DateUtil.getCurTimeFormat("yyyyMMddHH");
        this.success = 0L;
        this.failure = 0L;
        this.maxElapsed = 0L;
        this.maxConcurrent = 0;
        if (this.elements.size() > 0) {
            this.elements.clear();
        }
    }
}

