/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.proxy;

import com.ydn.jsrv.proxy.ProxyClass;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ProxyClassLoader
extends ClassLoader {
    protected Map<String, byte[]> byteCodeMap = new ConcurrentHashMap<String, byte[]>();

    public ProxyClassLoader() {
        super(ProxyClassLoader.getParentClassLoader());
    }

    protected static ClassLoader getParentClassLoader() {
        ClassLoader ret = Thread.currentThread().getContextClassLoader();
        return ret != null ? ret : ProxyClassLoader.class.getClassLoader();
    }

    public Class<?> loadProxyClass(ProxyClass proxyClass) {
        for (Map.Entry<String, byte[]> e : proxyClass.getByteCode().entrySet()) {
            this.byteCodeMap.putIfAbsent(e.getKey(), e.getValue());
        }
        try {
            return this.loadClass(proxyClass.getPkg() + "." + proxyClass.getName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] bytes = this.byteCodeMap.get(name);
        if (bytes != null) {
            Class<?> ret = this.defineClass(name, bytes, 0, bytes.length);
            this.byteCodeMap.remove(name);
            return ret;
        }
        return super.findClass(name);
    }

    static {
        ProxyClassLoader.registerAsParallelCapable();
    }
}

