/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.proxy;

import com.ydn.jsrv.proxy.ProxyClass;
import com.ydn.jsrv.proxy.ProxyClassLoader;
import com.ydn.jsrv.proxy.ProxyCompiler;
import com.ydn.jsrv.proxy.ProxyGenerator;
import com.ydn.jsrv.proxy.ProxyMethod;
import com.ydn.jsrv.proxy.ProxyMethodCache;
import java.lang.reflect.Modifier;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class ProxyFactory {
    protected ConcurrentHashMap<Class<?>, Class<?>> cache = new ConcurrentHashMap();
    protected ProxyGenerator proxyGenerator = new ProxyGenerator();
    protected ProxyCompiler proxyCompiler = new ProxyCompiler();
    protected ProxyClassLoader proxyClassLoader = new ProxyClassLoader();

    public <T> T get(Class<T> target) {
        try {
            Class<?> ret = this.cache.get(target);
            if (ret != null) {
                return (T)ret.newInstance();
            }
            return this.getProxyClass(target).newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> Class<T> getProxyClass(Class<T> target) throws ReflectiveOperationException {
        int mod = target.getModifiers();
        if (!Modifier.isPublic(mod)) {
            throw new IllegalArgumentException("Only public class can be proxied");
        }
        if (Modifier.isFinal(mod)) {
            throw new IllegalArgumentException("final class can not be proxied");
        }
        if (Modifier.isAbstract(mod)) {
            throw new IllegalArgumentException("abstract class or interface can not be proxied");
        }
        Class<T> clazz = target;
        synchronized (clazz) {
            Class<?> ret = this.cache.get(target);
            if (ret != null) {
                return ret;
            }
            ProxyClass proxyClass = this.proxyGenerator.generate(target);
            if (proxyClass.needProxy()) {
                this.proxyCompiler.compile(proxyClass);
                ret = this.proxyClassLoader.loadProxyClass(proxyClass);
                proxyClass.setClazz(ret);
                this.cacheMethodProxy(proxyClass);
                this.cache.put(target, ret);
                return ret;
            }
            this.cache.put(target, target);
            return target;
        }
    }

    protected void cacheMethodProxy(ProxyClass proxyClass) {
        for (ProxyMethod m : proxyClass.getProxyMethodList()) {
            m.setProxyClass(proxyClass.getClazz());
            ProxyMethodCache.put(m);
        }
    }

    public void setProxyGenerator(ProxyGenerator proxyGenerator) {
        Objects.requireNonNull(proxyGenerator, "proxyGenerator can not be null");
        this.proxyGenerator = proxyGenerator;
    }

    public ProxyGenerator getProxyGenerator() {
        return this.proxyGenerator;
    }

    public void setProxyCompiler(ProxyCompiler proxyCompiler) {
        Objects.requireNonNull(proxyCompiler, "proxyCompiler can not be null");
        this.proxyCompiler = proxyCompiler;
    }

    public ProxyCompiler getProxyCompiler() {
        return this.proxyCompiler;
    }

    public void setProxyClassLoader(ProxyClassLoader proxyClassLoader) {
        Objects.requireNonNull(proxyClassLoader, "proxyClassLoader can not be null");
        this.proxyClassLoader = proxyClassLoader;
    }

    public ProxyClassLoader getProxyClassLoader() {
        return this.proxyClassLoader;
    }
}

