/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.render;

import com.ydn.jsrv.core.JSrv;
import com.ydn.jsrv.exception.RenderException;
import com.ydn.jsrv.render.Render;
import java.io.IOException;

public class RedirectRender
extends Render {
    protected String url;
    protected boolean withQueryString;
    protected static final String contextPath = RedirectRender.getContxtPath();

    static String getContxtPath() {
        String cp = JSrv.me().getContextPath();
        return "".equals(cp) || "/".equals(cp) ? null : cp;
    }

    public RedirectRender(String url) {
        this.url = url;
        this.withQueryString = false;
    }

    public RedirectRender(String url, boolean withQueryString) {
        this.url = url;
        this.withQueryString = withQueryString;
    }

    public String buildUrl() {
        String queryString;
        String result = contextPath != null && (this.url.indexOf("://") == -1 || this.url.indexOf("://") > 5) ? contextPath + this.url : this.url;
        if (this.withQueryString && (queryString = this.request.getQueryString()) != null) {
            result = result.indexOf(63) == -1 ? result + "?" + queryString : result + "&" + queryString;
        }
        return result;
    }

    @Override
    public void render() {
        String renderUrl = this.buildUrl();
        try {
            this.response.sendRedirect(renderUrl);
        }
        catch (IOException e) {
            throw new RenderException(e);
        }
    }
}

