/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.render;

import com.ydn.jsrv.render.ErrorRender;
import com.ydn.jsrv.render.IRenderFactory;
import com.ydn.jsrv.render.JsonRender;
import com.ydn.jsrv.render.RedirectRender;
import com.ydn.jsrv.render.Render;
import com.ydn.jsrv.render.StringRender;
import com.ydn.jsrv.render.TemplateRender;
import com.ydn.jsrv.render.TextRender;
import com.ydn.jsrv.tool.captcha.CaptchaRender;
import com.ydn.jsrv.tool.template.Engine;
import com.ydn.jsrv.util.Ret;
import javax.servlet.ServletContext;

public class RenderFactory
implements IRenderFactory {
    protected Engine engine;
    protected ServletContext servletContext;

    @Override
    public void init(Engine engine, ServletContext servletContext) {
        this.engine = engine;
        this.servletContext = servletContext;
    }

    @Override
    public Render getErrorRender(int errorCode) {
        return new ErrorRender(errorCode);
    }

    @Override
    public Render getJsonRender() {
        return new JsonRender(Ret.ok());
    }

    @Override
    public Render getStringRender(String text) {
        return new StringRender(text);
    }

    @Override
    public Render getTextRender(String text) {
        return new TextRender(text);
    }

    @Override
    public Render getJsonRender(Ret ret) {
        return new JsonRender(ret);
    }

    @Override
    public Render getTemplateRender(String view) {
        return new TemplateRender(view);
    }

    @Override
    public Render getXmlRender(Object object) {
        return null;
    }

    @Override
    public Render getCaptchaRender() {
        return new CaptchaRender();
    }

    @Override
    public Render getRedirectRender(String url) {
        return new RedirectRender(url);
    }
}

