/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.tool.captcha;

import com.ydn.jsrv.core.Controller;
import com.ydn.jsrv.exception.RenderException;
import com.ydn.jsrv.render.Render;
import com.ydn.jsrv.tool.captcha.Captcha;
import com.ydn.jsrv.tool.captcha.CaptchaManager;
import com.ydn.jsrv.tool.captcha.ICaptchaCache;
import com.ydn.jsrv.util.LogUtil;
import com.ydn.jsrv.util.StrUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.QuadCurve2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CaptchaRender
extends Render {
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected static String captchaName = "_jsrv_captcha";
    protected static final Random random = new Random(System.nanoTime());
    protected static final int WIDTH = 108;
    protected static final int HEIGHT = 40;
    protected static final char[] charArray = "3456789ABCDEFGHJKMNPQRSTUVWXY".toCharArray();
    protected static final Font[] RANDOM_FONT = new Font[]{new Font("Dialog", 1, 33), new Font("DialogInput", 1, 34), new Font("Serif", 1, 33), new Font("SansSerif", 1, 34), new Font("Monospaced", 1, 34)};

    @Override
    public CaptchaRender setContext(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
        return this;
    }

    public static void setCaptchaName(String captchaName) {
        if (StrUtil.isBlank(captchaName)) {
            throw new IllegalArgumentException("captchaName can not be blank.");
        }
        CaptchaRender.captchaName = captchaName;
    }

    @Override
    public void render() {
        Captcha captcha = this.createCaptcha();
        CaptchaManager.me().getCaptchaCache().put(captcha);
        Cookie cookie = new Cookie(captchaName, captcha.getKey());
        cookie.setMaxAge(-1);
        cookie.setPath("/");
        this.response.addCookie(cookie);
        this.response.setHeader("Pragma", "no-cache");
        this.response.setHeader("Cache-Control", "no-cache");
        this.response.setDateHeader("Expires", 0L);
        this.response.setContentType("image/jpeg");
        ServletOutputStream sos = null;
        try {
            BufferedImage image = new BufferedImage(108, 40, 1);
            this.drawGraphic(captcha.getValue(), image);
            sos = this.response.getOutputStream();
            ImageIO.write((RenderedImage)image, "jpeg", (OutputStream)sos);
        }
        catch (Exception e) {
            throw new RenderException(e);
        }
        finally {
            if (sos != null) {
                try {
                    sos.close();
                }
                catch (IOException e) {
                    LogUtil.logNothing(e);
                }
            }
        }
    }

    protected Captcha createCaptcha() {
        String captchaKey = this.getCaptchaKeyFromCookie();
        if (StrUtil.isBlank(captchaKey)) {
            captchaKey = StrUtil.getRandomUUID();
        }
        return new Captcha(captchaKey, this.getRandomString(), 180);
    }

    protected String getCaptchaKeyFromCookie() {
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(captchaName)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    protected String getRandomString() {
        char[] randomChars = new char[4];
        for (int i = 0; i < randomChars.length; ++i) {
            randomChars[i] = charArray[random.nextInt(charArray.length)];
        }
        return String.valueOf(randomChars);
    }

    protected void drawGraphic(String randomString, BufferedImage image) {
        int i;
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setColor(this.getRandColor(210, 250));
        g.fillRect(0, 0, 108, 40);
        Color color = null;
        for (i = 0; i < 20; ++i) {
            color = this.getRandColor(120, 200);
            g.setColor(color);
            String rand = String.valueOf(charArray[random.nextInt(charArray.length)]);
            g.drawString(rand, random.nextInt(108), random.nextInt(40));
            color = null;
        }
        g.setFont(RANDOM_FONT[random.nextInt(RANDOM_FONT.length)]);
        for (i = 0; i < randomString.length(); ++i) {
            int degree = random.nextInt(28);
            if (i % 2 == 0) {
                degree *= -1;
            }
            int x = 22 * i;
            int y = 21;
            g.rotate(Math.toRadians(degree), x, y);
            color = this.getRandColor(20, 130);
            g.setColor(color);
            g.drawString(String.valueOf(randomString.charAt(i)), x + 8, y + 10);
            g.rotate(-Math.toRadians(degree), x, y);
        }
        g.setColor(color);
        BasicStroke bs = new BasicStroke(3.0f);
        g.setStroke(bs);
        QuadCurve2D.Double curve = new QuadCurve2D.Double(0.0, random.nextInt(32) + 4, 54.0, 20.0, 108.0, random.nextInt(32) + 4);
        g.draw(curve);
        g.dispose();
    }

    protected Color getRandColor(int fc, int bc) {
        Random random = new Random();
        if (fc > 255) {
            fc = 255;
        }
        if (bc > 255) {
            bc = 255;
        }
        int r = fc + random.nextInt(bc - fc);
        int g = fc + random.nextInt(bc - fc);
        int b = fc + random.nextInt(bc - fc);
        return new Color(r, g, b);
    }

    public static boolean validate(Controller controller, String userInputString) {
        String captchaKey = controller.getCookie(captchaName);
        if (CaptchaRender.validate(captchaKey, userInputString)) {
            controller.removeCookie(captchaName);
            return true;
        }
        return false;
    }

    public static boolean validate(String captchaKey, String userInputString) {
        ICaptchaCache captchaCache = CaptchaManager.me().getCaptchaCache();
        Captcha captcha = captchaCache.get(captchaKey);
        if (captcha != null && captcha.notExpired() && captcha.getValue().equalsIgnoreCase(userInputString)) {
            captchaCache.remove(captcha.getKey());
            return true;
        }
        return false;
    }
}

