/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.tool.generator;

import com.ydn.jsrv.tool.generator.TableMeta;
import com.ydn.jsrv.tool.template.Engine;
import com.ydn.jsrv.util.Kv;
import com.ydn.jsrv.util.LogUtil;
import com.ydn.jsrv.util.StrUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;

public class MappingGenerator {
    protected Engine engine;
    protected String template = "/com/ydn/jsrv/tool/generator/mapping_template.jf";
    protected String mappingOutPutDir;
    protected String mappingPackageName;
    protected String source;

    public MappingGenerator(String mappingPackageName, String mappingOutPutDir, String source) {
        this.source = source;
        this.mappingPackageName = mappingPackageName;
        this.mappingOutPutDir = mappingOutPutDir;
        this.initEngine();
    }

    protected void initEngine() {
        this.engine = new Engine();
        this.engine.setToClassPathSourceFactory();
        this.engine.addSharedMethod(new StrUtil());
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void generate(List<TableMeta> tableMetas) {
        System.out.println("Generate Mapping file ...");
        Kv data = new Kv();
        data.set("tableMetas", tableMetas);
        data.set("source", this.source);
        data.set("mappingPackageName", this.mappingPackageName);
        String ret = this.engine.getTemplate(this.template).renderToString(data);
        this.writeToFile(ret);
    }

    protected void writeToFile(String ret) {
        String target = this.mappingOutPutDir + File.separator + this.source + "_" + "mapping.xml";
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)new FileOutputStream(target), "UTF-8");
            osw.write(ret);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (IOException e) {
                    LogUtil.error(e.getMessage(), e);
                }
            }
        }
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }
}

