/*
 * Decompiled with CFR 0.152.
 */
package com.ydn.jsrv.tool.jwt;

import com.ydn.jsrv.util.StrUtil;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.Key;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class JwtTokenUtil {
    public static String generateJWT(Map<String, Object> claims, String key, long expireTime) throws Exception {
        SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.HS256;
        Date now = new Date();
        byte[] apiKeySecretBytes = DatatypeConverter.parseBase64Binary((String)key);
        SecretKeySpec signingKey = new SecretKeySpec(apiKeySecretBytes, signatureAlgorithm.getJcaName());
        HashMap<String, String> headMap = new HashMap<String, String>();
        headMap.put("alg", SignatureAlgorithm.HS256.getValue());
        headMap.put("typ", "JWT");
        JwtBuilder builder = Jwts.builder().setHeader(headMap);
        builder.setClaims(claims);
        builder.signWith(signatureAlgorithm, (Key)signingKey);
        long expMillis = now.getTime() + expireTime;
        Date expDate = new Date(expMillis);
        builder.setExpiration(expDate).setNotBefore(now);
        builder.setIssuedAt(now);
        return builder.compact();
    }

    public static String generalKey() {
        String uuid = UUID.randomUUID().toString();
        uuid = uuid.replaceAll("-", "");
        return uuid;
    }

    public static Claims parseJWT(String jsonWebToken, String key) throws Exception {
        if (StrUtil.isBlank(jsonWebToken) || StrUtil.isBlank(key)) {
            return null;
        }
        Claims claims = (Claims)Jwts.parser().setSigningKey(DatatypeConverter.parseBase64Binary((String)key)).parseClaimsJws(jsonWebToken).getBody();
        return claims;
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("appId", "123");
        param.put("userName", "zhangsan");
        String key = JwtTokenUtil.generalKey();
        System.out.println(key);
        String jsonWebKey = JwtTokenUtil.generateJWT(param, key, 1800000L);
        System.out.println(jsonWebKey);
        Claims claims = JwtTokenUtil.parseJWT(jsonWebKey, key);
        System.out.println(claims);
    }
}

